// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.DateCeilFloorMonotonic;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullLiteral;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullable;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.DateTimeV2Type;
import org.apache.doris.nereids.types.IntegerType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'hour_floor'. This class is generated by GenerateFunction.
 */
public class HourFloor extends ScalarFunction
        implements ExplicitlyCastableSignature, PropagateNullLiteral, PropagateNullable, DateCeilFloorMonotonic {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(DateTimeV2Type.WILDCARD).args(DateTimeV2Type.WILDCARD),
            FunctionSignature.ret(DateTimeV2Type.WILDCARD)
                    .args(DateTimeV2Type.WILDCARD, DateTimeV2Type.WILDCARD),
            FunctionSignature.ret(DateTimeV2Type.WILDCARD)
                    .args(DateTimeV2Type.WILDCARD, IntegerType.INSTANCE),
            FunctionSignature.ret(DateTimeV2Type.WILDCARD)
                    .args(DateTimeV2Type.WILDCARD, IntegerType.INSTANCE, DateTimeV2Type.WILDCARD)
    );

    /**
     * constructor with 1 argument.
     */
    public HourFloor(Expression arg) {
        super("hour_floor", arg);
    }

    /**
     * constructor with 2 arguments.
     */
    public HourFloor(Expression arg0, Expression arg1) {
        super("hour_floor", arg0, arg1);
    }

    /**
     * constructor with 3 arguments.
     */
    public HourFloor(Expression arg0, Expression arg1, Expression arg2) {
        super("hour_floor", arg0, arg1, arg2);
    }

    /** constructor for withChildren and reuse signature */
    private HourFloor(ScalarFunctionParams functionParams) {
        super(functionParams);
    }

    /**
     * withChildren.
     */
    @Override
    public HourFloor withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 1
                || children.size() == 2
                || children.size() == 3);
        return new HourFloor(getFunctionParams(children));
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitHourFloor(this, context);
    }

    @Override
    public Expression withConstantArgs(Expression literal) {
        switch (arity()) {
            case 1:
                return new HourFloor(literal);
            case 2:
                return new HourFloor(literal, child(1));
            case 3:
                return new HourFloor(literal, child(1), child(2));
            default:
                throw new IllegalStateException("The function " + getName() + " has invalid child number.");
        }
    }
}
