/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.FrameWriterSpec;
import org.apache.druid.msq.exec.MSQMetriceEventBuilder;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;
import org.apache.druid.msq.exec.TaskDataSegmentProvider;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.IndexerDataServerQueryHandlerFactory;
import org.apache.druid.msq.indexing.IndexerFrameContext;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.indexing.client.IndexerControllerClient;
import org.apache.druid.msq.indexing.client.IndexerWorkerClient;
import org.apache.druid.msq.indexing.client.WorkerChatHandler;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SpecificTaskRetryPolicy;
import org.apache.druid.rpc.indexing.SpecificTaskServiceLocator;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorProvider;

public class IndexerWorkerContext
implements WorkerContext {
    private static final Logger log = new Logger(IndexerWorkerContext.class);
    private final MSQWorkerTask task;
    private final TaskToolbox toolbox;
    private final Injector injector;
    private final OverlordClient overlordClient;
    private final ServiceLocator controllerLocator;
    private final IndexIO indexIO;
    private final TaskDataSegmentProvider dataSegmentProvider;
    private final IndexerDataServerQueryHandlerFactory dataServerQueryHandlerFactory;
    private final ServiceClientFactory clientFactory;
    private final MemoryIntrospector memoryIntrospector;
    private final ProcessingBuffersProvider processingBuffersProvider;
    private final int maxConcurrentStages;
    private final boolean includeAllCounters;
    private volatile ResourceHolder<ProcessingBuffersSet> processingBuffersSet;

    public IndexerWorkerContext(MSQWorkerTask task, TaskToolbox toolbox, Injector injector, OverlordClient overlordClient, ServiceLocator controllerLocator, IndexIO indexIO, TaskDataSegmentProvider dataSegmentProvider, ServiceClientFactory clientFactory, MemoryIntrospector memoryIntrospector, ProcessingBuffersProvider processingBuffersProvider, IndexerDataServerQueryHandlerFactory dataServerQueryHandlerFactory) {
        this.task = task;
        this.toolbox = toolbox;
        this.overlordClient = overlordClient;
        this.controllerLocator = controllerLocator;
        this.indexIO = indexIO;
        this.dataSegmentProvider = dataSegmentProvider;
        this.clientFactory = clientFactory;
        this.memoryIntrospector = memoryIntrospector;
        this.processingBuffersProvider = processingBuffersProvider;
        this.dataServerQueryHandlerFactory = dataServerQueryHandlerFactory;
        QueryContext queryContext = QueryContext.of((Map)task.getContext());
        this.maxConcurrentStages = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(queryContext, 1);
        this.includeAllCounters = MultiStageQueryContext.getIncludeAllCounters(queryContext);
        StorageConnectorProvider storageConnectorProvider = (StorageConnectorProvider)injector.getInstance(Key.get(StorageConnectorProvider.class, MultiStageQuery.class));
        StorageConnector storageConnector = storageConnectorProvider.createStorageConnector(toolbox.getIndexingTmpDir());
        this.injector = injector.createChildInjector(new Module[]{binder -> binder.bind(Key.get(StorageConnector.class, MultiStageQuery.class)).toInstance((Object)storageConnector)});
    }

    public static IndexerWorkerContext createProductionInstance(MSQWorkerTask task, TaskToolbox toolbox, Injector injector) {
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        SegmentCacheManager segmentCacheManager = ((SegmentCacheManagerFactory)injector.getInstance(SegmentCacheManagerFactory.class)).manufacturate(new File(toolbox.getIndexingTmpDir(), "segment-fetch"));
        ServiceClientFactory serviceClientFactory = (ServiceClientFactory)injector.getInstance(Key.get(ServiceClientFactory.class, EscalatedGlobal.class));
        MemoryIntrospector memoryIntrospector = (MemoryIntrospector)injector.getInstance(MemoryIntrospector.class);
        OverlordClient overlordClient = ((OverlordClient)injector.getInstance(OverlordClient.class)).withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ProcessingBuffersProvider processingBuffersProvider = (ProcessingBuffersProvider)injector.getInstance(ProcessingBuffersProvider.class);
        ObjectMapper smileMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Smile.class));
        QueryToolChestWarehouse warehouse = (QueryToolChestWarehouse)injector.getInstance(QueryToolChestWarehouse.class);
        return new IndexerWorkerContext(task, toolbox, injector, overlordClient, (ServiceLocator)new SpecificTaskServiceLocator(task.getControllerTaskId(), overlordClient), indexIO, new TaskDataSegmentProvider(toolbox.getCoordinatorClient(), segmentCacheManager, indexIO), serviceClientFactory, memoryIntrospector, processingBuffersProvider, new IndexerDataServerQueryHandlerFactory(toolbox.getCoordinatorClient(), serviceClientFactory, smileMapper, warehouse));
    }

    @Override
    public String queryId() {
        return this.task.getControllerTaskId();
    }

    @Override
    public String workerId() {
        return this.task.getId();
    }

    public TaskToolbox toolbox() {
        return this.toolbox;
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.toolbox.getJsonMapper();
    }

    @Override
    public PolicyEnforcer policyEnforcer() {
        return this.toolbox.getPolicyEnforcer();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void emitMetric(MSQMetriceEventBuilder metricBuilder) {
        metricBuilder.setTaskDimensions((Task)this.task, QueryContext.of((Map)this.task.getContext()));
        this.toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder);
    }

    @Override
    public void registerWorker(Worker worker, Closer closer) {
        WorkerChatHandler chatHandler = new WorkerChatHandler(worker, this.toolbox.getAuthorizerMapper(), this.task.getDataSource());
        this.toolbox.getChatHandlerProvider().register(worker.id(), (ChatHandler)chatHandler, false);
        closer.register(() -> this.toolbox.getChatHandlerProvider().unregister(worker.id()));
    }

    @Override
    public File tempDir() {
        return this.toolbox.getIndexingTmpDir();
    }

    @Override
    public int maxConcurrentStages() {
        return this.maxConcurrentStages;
    }

    @Override
    public ControllerClient makeControllerClient() {
        return new IndexerControllerClient(this.clientFactory.makeClient(this.task.getControllerTaskId(), this.controllerLocator, (ServiceRetryPolicy)new SpecificTaskRetryPolicy(this.task.getControllerTaskId(), (ServiceRetryPolicy)StandardRetryPolicy.unlimited())), this.jsonMapper(), (Closeable)this.controllerLocator);
    }

    @Override
    public WorkerClient makeWorkerClient() {
        return new IndexerWorkerClient(this.clientFactory, this.overlordClient, this.jsonMapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameContext frameContext(WorkOrder workOrder) {
        if (this.processingBuffersSet == null) {
            IndexerWorkerContext indexerWorkerContext = this;
            synchronized (indexerWorkerContext) {
                if (this.processingBuffersSet == null) {
                    this.processingBuffersSet = this.processingBuffersProvider.acquire(workOrder.getQueryDefinition(), this.maxConcurrentStages());
                }
            }
        }
        WorkerMemoryParameters memoryParameters = WorkerMemoryParameters.createProductionInstance(workOrder, this.memoryIntrospector, this.maxConcurrentStages);
        log.info("Memory parameters for stage[%s]: %s", new Object[]{workOrder.getStageDefinition().getId(), memoryParameters});
        return new IndexerFrameContext(workOrder.getStageDefinition().getId(), this, FrameWriterSpec.fromContext(workOrder.getWorkerContext()), this.indexIO, this.dataSegmentProvider, ((ProcessingBuffersSet)this.processingBuffersSet.get()).acquireForStage(workOrder.getStageDefinition()), this.dataServerQueryHandlerFactory, memoryParameters, WorkerStorageParameters.createProductionInstance(this.injector, workOrder.getOutputChannelMode()));
    }

    @Override
    public int threadCount() {
        return this.memoryIntrospector.numProcessingThreads();
    }

    @Override
    public DruidNode selfNode() {
        return this.toolbox.getDruidNode();
    }

    @Override
    public DataServerQueryHandlerFactory dataServerQueryHandlerFactory() {
        return this.dataServerQueryHandlerFactory;
    }

    @Override
    public boolean includeAllCounters() {
        return this.includeAllCounters;
    }

    public ServiceLocator controllerLocator() {
        return this.controllerLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.controllerLocator.close();
        IndexerWorkerContext indexerWorkerContext = this;
        synchronized (indexerWorkerContext) {
            if (this.processingBuffersSet != null) {
                this.processingBuffersSet.close();
                this.processingBuffersSet = null;
            }
        }
    }
}

