/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;

public class MSQResourceUtils {
    public static void authorizeAdminRequest(ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper, HttpServletRequest request) {
        List<ResourceAction> resourceActions = permissionMapper.getAdminPermissions();
        AuthorizationResult authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, resourceActions, (AuthorizerMapper)authorizerMapper);
        if (!authResult.allowAccessWithNoRestriction()) {
            throw new ForbiddenException(authResult.getErrorMessage());
        }
    }

    public static void authorizeQueryRequest(ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper, HttpServletRequest request, String queryId) {
        List<ResourceAction> resourceActions = permissionMapper.getQueryPermissions(queryId);
        AuthorizationResult authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, resourceActions, (AuthorizerMapper)authorizerMapper);
        if (!authResult.allowAccessWithNoRestriction()) {
            throw new ForbiddenException(authResult.getErrorMessage());
        }
    }
}

