/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.eventmesh.openconnect.offsetmgmt.api.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RecordPartition {

    /**
     * if pull message from mq key=topic,
     * value=topicName key=brokerName,
     * value=brokerName key=queueId,
     * value=queueId
     */
    private Map<String, ?> partition = new HashMap<>();

    public RecordPartition() {

    }

    public RecordPartition(Map<String, ?> partition) {
        this.partition = partition;
    }

    public Map<String, ?> getPartition() {
        return partition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordPartition)) {
            return false;
        }
        RecordPartition partition1 = (RecordPartition) o;
        return Objects.equals(partition, partition1.partition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partition);
    }
}
