/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Frame;
import flash.tools.debugger.IsolateController;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.expression.PlayerFaultException;

public class IsolatePlayerSession
implements IsolateSession {
    private IsolateController fSession;
    private int fIsolateId;

    public IsolatePlayerSession(int isolateId, IsolateController mainSession) {
        this.fIsolateId = isolateId;
        this.fSession = mainSession;
    }

    public void resume() throws NotSuspendedException, NotConnectedException, NoResponseException {
        this.fSession.resumeWorker(this.fIsolateId);
    }

    public void suspend() throws SuspendedException, NotConnectedException, NoResponseException {
        this.fSession.suspendWorker(this.fIsolateId);
    }

    public boolean isSuspended() throws NotConnectedException {
        return this.fSession.isWorkerSuspended(this.fIsolateId);
    }

    public int suspendReason() throws NotConnectedException {
        return this.fSession.suspendReasonWorker(this.fIsolateId);
    }

    public Frame[] getFrames() throws NotConnectedException {
        return this.fSession.getFramesWorker(this.fIsolateId);
    }

    public void stepInto() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.fSession.stepIntoWorker(this.fIsolateId);
    }

    public void stepOut() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.fSession.stepOutWorker(this.fIsolateId);
    }

    public void stepOver() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.fSession.stepOverWorker(this.fIsolateId);
    }

    public void stepContinue() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.fSession.stepContinueWorker(this.fIsolateId);
    }

    public SwfInfo[] getSwfs() throws NoResponseException {
        return this.fSession.getSwfsWorker(this.fIsolateId);
    }

    public Location setBreakpoint(int fileId, int lineNum) throws NoResponseException, NotConnectedException {
        return this.fSession.setBreakpointWorker(fileId, lineNum, this.fIsolateId);
    }

    public Watch[] getWatchList() throws NoResponseException, NotConnectedException {
        return this.fSession.getWatchListWorker(this.fIsolateId);
    }

    public Variable[] getVariableList() throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        return this.fSession.getVariableListWorker(this.fIsolateId);
    }

    public Value getValue(long valueId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.fSession.getValueWorker(valueId, this.fIsolateId);
    }

    public Value getGlobal(String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.fSession.getGlobalWorker(name, this.fIsolateId);
    }

    public boolean evalIs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalIsWorker(value, type, this.fIsolateId);
    }

    public boolean evalIs(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalIsWorker(value, type, this.fIsolateId);
    }

    public boolean evalInstanceof(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalInstanceofWorker(value, type, this.fIsolateId);
    }

    public boolean evalInstanceof(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalInstanceofWorker(value, type, this.fIsolateId);
    }

    public boolean evalIn(Value property, Value object) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalInWorker(property, object, this.fIsolateId);
    }

    public Value evalAs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.fSession.evalAsWorker(value, type, this.fIsolateId);
    }

    public Value callFunction(Value thisObject, String functionName, Value[] args) throws PlayerDebugException {
        return this.fSession.callFunctionWorker(thisObject, functionName, args, this.fIsolateId);
    }

    public Value callConstructor(String classname, Value[] args) throws PlayerDebugException {
        return this.fSession.callConstructorWorker(classname, args, this.fIsolateId);
    }

    public boolean setExceptionBreakpoint(String exceptionClass) throws NoResponseException, NotConnectedException {
        return this.fSession.setExceptionBreakpointWorker(exceptionClass, this.fIsolateId);
    }

    public boolean clearExceptionBreakpoint(String exceptionClass) throws NoResponseException, NotConnectedException {
        return this.fSession.clearExceptionBreakpointWorker(exceptionClass, this.fIsolateId);
    }

    public void breakOnCaughtExceptions(boolean b) throws NotSupportedException, NoResponseException {
        this.fSession.breakOnCaughtExceptions(b, this.fIsolateId);
    }

    public boolean supportsWatchpoints() {
        return this.fSession.supportsWatchpoints(this.fIsolateId);
    }

    public boolean playerCanBreakOnAllExceptions() {
        return this.fSession.playerCanBreakOnAllExceptions(this.fIsolateId);
    }

    public boolean supportsWideLineNumbers() {
        return this.fSession.supportsWideLineNumbers(this.fIsolateId);
    }

    public boolean playerCanCallFunctions() {
        return this.fSession.playerCanCallFunctions(this.fIsolateId);
    }
}

