/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.flex.forks.util.SerializedTemplateFactory;
import org.apache.flex.forks.velocity.Template;
import org.apache.flex.forks.velocity.VelocityContext;
import org.apache.flex.forks.velocity.app.VelocityEngine;
import org.apache.flex.forks.velocity.app.event.EventCartridge;
import org.apache.flex.forks.velocity.app.event.EventHandler;
import org.apache.flex.forks.velocity.app.event.MethodExceptionEventHandler;
import org.apache.flex.forks.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.flex.forks.velocity.context.Context;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.log.LogSystem;
import org.apache.flex.forks.velocity.util.introspection.Info;
import org.apache.flex.forks.velocity.util.introspection.UberspectImpl;
import org.apache.flex.forks.velocity.util.introspection.VelPropertyGet;
import org.apache.flex.forks.velocity.util.introspection.VelPropertySet;

public class VelocityManager {
    private static final String LOGSYSTEM_CLASS = "flex2.compiler.util.VelocityManager$Logger";
    private static final String STRICT_UBERSPECT_IMPL_CLASS = "flex2.compiler.util.VelocityManager$StrictUberspectImpl";
    private static final String CLASSPATH_RESOURCE_LOADER_CLASS = "org.apache.flex.forks.velocity.runtime.resource.loader.ClasspathResourceLoader";
    private static final String UTIL_KEY = "util";
    private static final Map<String, VelocityEngine> engines = new Hashtable<String, VelocityEngine>();
    private static final Map<String, Template> templates = new Hashtable<String, Template>();

    private static final VelocityEngine createEngine(String lib) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.logsystem.class", (Object)LOGSYSTEM_CLASS);
        ve.setProperty("runtime.log.error.stacktrace", (Object)"false");
        ve.setProperty("runtime.log.invalid.references", (Object)"true");
        ve.setProperty("runtime.introspector.uberspect", (Object)STRICT_UBERSPECT_IMPL_CLASS);
        ve.setProperty("resource.loader", (Object)"file,class");
        ve.setProperty("class.resource.loader.class", (Object)CLASSPATH_RESOURCE_LOADER_CLASS);
        ve.setProperty("velocimacro.library", (Object)"");
        try {
            ve.init();
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new InitializationError(e.getLocalizedMessage()));
        }
        if (lib != null && ve != null) {
            VelocityManager.getTemplate(lib, ve);
        }
        return ve;
    }

    private static final VelocityEngine getEngine(String lib) {
        String libKey = lib == null ? "" : lib;
        VelocityEngine ve = engines.get(libKey);
        if (ve == null) {
            ve = VelocityManager.createEngine(lib);
        }
        if (ve != null) {
            engines.put(libKey, ve);
        }
        return ve;
    }

    public static Template getTemplate(String path) {
        return VelocityManager.getTemplate(path, (String)null);
    }

    public static Template getTemplate(String path, String lib) {
        VelocityEngine ve = VelocityManager.getEngine(lib);
        String templateKey = path + (lib == null ? "" : lib);
        Template t = templates.get(templateKey);
        if (t == null) {
            t = VelocityManager.getTemplate(path, ve);
            templates.put(templateKey, t);
        }
        return t;
    }

    private static Template getTemplate(String path, VelocityEngine ve) {
        try {
            Template t = SerializedTemplateFactory.load((String)(path + "s"));
            t.setRuntimeServices(ve.getRuntimeServices());
            t.setName(path);
            t.initDocument();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static VelocityContext getCodeGenContext(Util util) {
        VelocityContext cx = new VelocityContext();
        if (util == null) {
            util = new Util();
        }
        if (util instanceof EventHandler) {
            EventCartridge ec = new EventCartridge();
            ec.addEventHandler((EventHandler)util);
            ec.attachToContext((Context)cx);
        }
        cx.put(UTIL_KEY, (Object)util);
        return cx;
    }

    public static VelocityContext getCodeGenContext() {
        return VelocityManager.getCodeGenContext(null);
    }

    public static class SetMethodNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4644689922730063246L;
        public final String template;
        public final String identifier;
        public final String className;
        public final int line;
        public final int column;

        public SetMethodNotFound(String template, int line, int column, String identifier, String className) {
            this.template = template;
            this.line = line;
            this.column = column;
            this.identifier = identifier;
            this.className = className;
        }
    }

    public static class GetMethodNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2870457973013490956L;
        public final String template;
        public final String identifier;
        public final String className;
        public final int line;
        public final int column;

        public GetMethodNotFound(String template, int line, int column, String identifier, String className) {
            this.template = template;
            this.line = line;
            this.column = column;
            this.identifier = identifier;
            this.className = className;
        }
    }

    public static class TemplateReferenceIsNull
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4029561325397237572L;
        public final String s;

        public TemplateReferenceIsNull(String s) {
            this.s = s;
        }
    }

    public static class InvocationError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8490870052703007082L;
        public final String className;
        public final String methodName;
        public final String message;

        public InvocationError(String className, String methodName, String message) {
            this.className = className;
            this.methodName = methodName;
            this.message = message;
        }
    }

    public static class InitializationError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6605160202727369019L;
        public final String message;

        public InitializationError(String message) {
            this.message = message;
        }
    }

    public static class Logger
    implements LogSystem {
        LogSystem als = null;

        public void init(RuntimeServices rs) throws Exception {
        }

        public void logVelocityMessage(int level, String message) {
            if (!(level != 3 || message.equals("VM #writeWatcher: error : too few arguments to macro. Wanted 1 got 0") || message.equals("VM #writeEvaluationWatcherPart: error : too few arguments to macro. Wanted 2 got 0") || message.equals("VM #writeWatcherBottom: error : too few arguments to macro. Wanted 1 got 0"))) {
                ThreadLocalToolkit.logWarning(message);
            }
            if (this.als != null) {
                this.als.logVelocityMessage(level, message);
            }
        }
    }

    public static class StrictUberspectImpl
    extends UberspectImpl {
        public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
            VelPropertyGet getter = super.getPropertyGet(obj, identifier, i);
            try {
                getter.getMethodName();
            }
            catch (NullPointerException e) {
                ThreadLocalToolkit.log(new GetMethodNotFound(i.getTemplateName(), i.getLine(), i.getColumn(), identifier, obj.getClass().getName()));
            }
            return getter;
        }

        public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
            VelPropertySet setter = super.getPropertySet(obj, identifier, arg, i);
            if (setter == null) {
                ThreadLocalToolkit.log(new SetMethodNotFound(i.getTemplateName(), i.getLine(), i.getColumn(), identifier, obj.getClass().getName()));
            }
            return setter;
        }
    }

    public static class Util
    implements MethodExceptionEventHandler,
    ReferenceInsertionEventHandler {
        static Format dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");

        public static long Now() {
            return System.currentTimeMillis();
        }

        public static String getTimeStamp() {
            return dateTimeFormat.format(new Date(Util.Now()));
        }

        public final Object methodException(Class claz, String methodName, Exception e) throws Exception {
            ThreadLocalToolkit.log(new InvocationError(claz.getName(), methodName, e.getLocalizedMessage()));
            return null;
        }

        public Object referenceInsert(String s, Object o) {
            if (o == null) {
                ThreadLocalToolkit.log(new TemplateReferenceIsNull(s));
            }
            return o;
        }
    }
}

