/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.util.Preconditions;

@Internal
public class CompactorRequest
implements Serializable {
    private final String bucketId;
    private final List<FileSinkCommittable> committableToCompact;
    private final List<FileSinkCommittable> committableToPassthrough;

    public CompactorRequest(String bucketId) {
        this.bucketId = bucketId;
        this.committableToCompact = new ArrayList<FileSinkCommittable>();
        this.committableToPassthrough = new ArrayList<FileSinkCommittable>();
    }

    public CompactorRequest(String bucketId, List<FileSinkCommittable> committableToCompact, List<FileSinkCommittable> committableToPassthrough) {
        this.bucketId = bucketId;
        this.committableToCompact = committableToCompact;
        this.committableToPassthrough = committableToPassthrough;
    }

    public void addToCompact(FileSinkCommittable committable) {
        Preconditions.checkState((boolean)committable.hasPendingFile());
        this.committableToCompact.add(committable);
    }

    public void addToPassthrough(FileSinkCommittable committable) {
        this.committableToPassthrough.add(committable);
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public List<FileSinkCommittable> getCommittableToCompact() {
        return this.committableToCompact;
    }

    public List<FileSinkCommittable> getCommittableToPassthrough() {
        return this.committableToPassthrough;
    }
}

