/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.util.Preconditions;

@Internal
public class UnloadModuleOperation
implements Operation,
ExecutableOperation {
    private final String moduleName;

    public UnloadModuleOperation(String moduleName) {
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String asSummaryString() {
        return String.format("UNLOAD MODULE %s", this.moduleName);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getModuleManager().unloadModule(this.getModuleName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("Could not execute %s. %s", this.asSummaryString(), e.getMessage()), e);
        }
    }
}

