/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ArrayComparableElementTypeStrategy
implements InputTypeStrategy {
    private final StructuredType.StructuredComparison requiredComparison;
    private final ConstantArgumentCount argumentCount;

    public ArrayComparableElementTypeStrategy(StructuredType.StructuredComparison requiredComparison) {
        Preconditions.checkArgument((requiredComparison != StructuredType.StructuredComparison.NONE ? 1 : 0) != 0);
        this.requiredComparison = requiredComparison;
        this.argumentCount = ConstantArgumentCount.of(1);
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType argumentType = argumentDataTypes.get(0);
        if (!argumentType.getLogicalType().is(LogicalTypeRoot.ARRAY)) {
            return callContext.fail(throwOnFailure, "All arguments requires to be an ARRAY type", new Object[0]);
        }
        DataType elementDataType = ((CollectionDataType)argumentType).getElementDataType();
        LogicalType elementLogicalDataType = elementDataType.getLogicalType();
        if (!this.areComparable(elementLogicalDataType, elementLogicalDataType)) {
            return callContext.fail(throwOnFailure, "Type '%s' should support %s comparison with itself.", elementLogicalDataType, this.comparisonToString());
        }
        return Optional.of(argumentDataTypes);
    }

    private String comparisonToString() {
        return this.requiredComparison == StructuredType.StructuredComparison.EQUALS ? "'EQUALS'" : "both 'EQUALS' and 'ORDER'";
    }

    private boolean areComparable(LogicalType firstType, LogicalType secondType) {
        return this.areComparableWithNormalizedNullability(firstType.copy(true), secondType.copy(true));
    }

    private boolean areComparableWithNormalizedNullability(LogicalType firstType, LogicalType secondType) {
        if (firstType instanceof LegacyTypeInformationType || secondType instanceof LegacyTypeInformationType) {
            return true;
        }
        if (firstType.is(LogicalTypeRoot.NULL) || secondType.is(LogicalTypeRoot.NULL)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.NUMERIC) && secondType.is(LogicalTypeFamily.NUMERIC)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.DATETIME) && secondType.is(LogicalTypeFamily.DATETIME)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.CHARACTER_STRING) && secondType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        return firstType.is(LogicalTypeFamily.BINARY_STRING) && secondType.is(LogicalTypeFamily.BINARY_STRING);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup("ARRAY<COMPARABLE>")));
    }
}

