/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.grouping;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.Preconditions;

public abstract class WindowsGrouping
implements Closeable {
    private final long windowStartOffset;
    private final long windowSize;
    private final long slideSize;
    private final int timeIndex;
    private long watermark;
    private TimeWindow nextWindow;
    private TimeWindow currentWindow;
    private int triggerWindowStartIndex;
    private boolean emptyWindowTriggered;
    private boolean isDate;

    WindowsGrouping(long windowSize, long slideSize, int timestampIndex, boolean isDate) {
        this(0L, windowSize, slideSize, timestampIndex, isDate);
    }

    WindowsGrouping(long offset, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        this.windowStartOffset = offset;
        this.windowSize = windowSize;
        this.slideSize = slideSize;
        this.timeIndex = timeIndex;
        this.isDate = isDate;
        this.nextWindow = null;
        this.watermark = Long.MIN_VALUE;
        this.triggerWindowStartIndex = 0;
        this.emptyWindowTriggered = true;
    }

    public void reset() {
        this.nextWindow = null;
        this.watermark = Long.MIN_VALUE;
        this.triggerWindowStartIndex = 0;
        this.emptyWindowTriggered = true;
        this.resetBuffer();
    }

    public void addInputToBuffer(BinaryRowData input) throws IOException {
        if (!input.isNullAt(this.timeIndex)) {
            this.addIntoBuffer(input.copy());
            this.advanceWatermark(this.getTimeValue((RowData)input));
        }
    }

    public void advanceWatermarkToTriggerAllWindows() {
        this.skipEmptyWindow();
        this.advanceWatermark(this.watermark + this.windowSize);
    }

    public boolean hasTriggerWindow() {
        this.skipEmptyWindow();
        Preconditions.checkState((this.watermark == Long.MIN_VALUE || this.nextWindow != null ? 1 : 0) != 0, (Object)"next trigger window cannot be null.");
        return this.nextWindow != null && this.nextWindow.getEnd() <= this.watermark;
    }

    public RowIterator<BinaryRowData> buildTriggerWindowElementsIterator() {
        this.currentWindow = this.nextWindow;
        Preconditions.checkState((this.watermark == Long.MIN_VALUE || this.nextWindow != null ? 1 : 0) != 0, (Object)"next trigger window cannot be null.");
        if (this.nextWindow.getEnd() > this.watermark) {
            throw new IllegalStateException("invalid window triggered " + this.currentWindow);
        }
        this.nextWindow = TimeWindow.of(this.currentWindow.getStart() + this.slideSize, this.currentWindow.getStart() + this.slideSize + this.windowSize);
        this.emptyWindowTriggered = true;
        this.onBufferEvict(this.triggerWindowStartIndex);
        return new WindowsElementsIterator(this.newBufferIterator(this.triggerWindowStartIndex));
    }

    public TimeWindow getTriggerWindow() {
        return this.currentWindow;
    }

    private boolean belongsToCurrentWindow(BinaryRowData element) {
        long currentTimestamp = this.getTimeValue((RowData)element);
        if (currentTimestamp >= this.currentWindow.getStart() && currentTimestamp < this.currentWindow.getEnd()) {
            this.evictForWindow(element, this.nextWindow);
            return true;
        }
        return false;
    }

    private boolean evictForWindow(BinaryRowData element, TimeWindow window) {
        if (this.getTimeValue((RowData)element) < window.getStart()) {
            ++this.triggerWindowStartIndex;
            return true;
        }
        return false;
    }

    private void advanceWatermark(long timestamp) {
        this.watermark = timestamp;
    }

    private void skipEmptyWindow() {
        if (this.emptyWindowTriggered && this.watermark != Long.MIN_VALUE) {
            this.nextWindow = this.advanceNextWindowByWatermark(this.watermark);
            this.emptyWindowTriggered = false;
        }
    }

    private TimeWindow advanceNextWindowByWatermark(long watermark) {
        long nextStart;
        int maxOverlapping = (int)Math.ceil((double)this.windowSize * 1.0 / (double)this.slideSize);
        long start = this.getWindowStartWithOffset(watermark, this.windowStartOffset, this.slideSize);
        for (int i = 1; i < maxOverlapping && (nextStart = start - this.slideSize) + this.windowSize > watermark; ++i) {
            start = nextStart;
        }
        if (this.nextWindow == null || start > this.nextWindow.getStart()) {
            return TimeWindow.of(start, start + this.windowSize);
        }
        return this.nextWindow;
    }

    private long getWindowStartWithOffset(long timestamp, long offset, long windowSize) {
        long remainder = (timestamp - offset) % windowSize;
        if (remainder < 0L) {
            return timestamp - (remainder + windowSize);
        }
        return timestamp - remainder;
    }

    private long getTimeValue(RowData row) {
        if (this.isDate) {
            return (long)row.getInt(this.timeIndex) * 86400000L;
        }
        return row.getLong(this.timeIndex);
    }

    protected abstract void resetBuffer();

    protected abstract void addIntoBuffer(BinaryRowData var1) throws IOException;

    protected abstract void onBufferEvict(int var1);

    protected abstract RowIterator<BinaryRowData> newBufferIterator(int var1);

    class WindowsElementsIterator
    implements RowIterator<BinaryRowData> {
        private final RowIterator<BinaryRowData> bufferIterator;
        private BinaryRowData next;

        WindowsElementsIterator(RowIterator<BinaryRowData> iterator) {
            this.bufferIterator = iterator;
        }

        @Override
        public boolean advanceNext() {
            do {
                if (!this.bufferIterator.advanceNext()) {
                    this.next = null;
                    return false;
                }
                this.next = this.bufferIterator.getRow();
            } while (WindowsGrouping.this.evictForWindow(this.next, WindowsGrouping.this.currentWindow));
            if (WindowsGrouping.this.belongsToCurrentWindow(this.next)) {
                WindowsGrouping.this.emptyWindowTriggered = false;
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public BinaryRowData getRow() {
            return this.next;
        }
    }
}

