/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ArrayComparableElementArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ArrayElementArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CastInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CurrentWatermarkInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExtractInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.JsonQueryOnErrorEmptyArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MapInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OverTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ReinterpretCastInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SubQueryInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.TemporalOverlapsInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.WindowTimeIndictorInputTypeStrategy;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampKind;

@Internal
public final class SpecificInputTypeStrategies {
    public static final InputTypeStrategy CAST = new CastInputTypeStrategy();
    public static final InputTypeStrategy REINTERPRET_CAST = new ReinterpretCastInputTypeStrategy();
    public static final InputTypeStrategy MAP = new MapInputTypeStrategy();
    public static final InputTypeStrategy CURRENT_WATERMARK = new CurrentWatermarkInputTypeStrategy();
    public static final InputTypeStrategy OVER = new OverTypeStrategy();
    public static final ArgumentTypeStrategy JSON_ARGUMENT = InputTypeStrategies.or(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.BINARY_STRING), InputTypeStrategies.logical(LogicalTypeFamily.TIMESTAMP), InputTypeStrategies.logical(LogicalTypeFamily.CONSTRUCTED), InputTypeStrategies.logical(LogicalTypeRoot.STRUCTURED_TYPE), InputTypeStrategies.logical(LogicalTypeRoot.DISTINCT_TYPE), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC));
    public static final ArgumentTypeStrategy JSON_QUERY_ON_EMPTY_ERROR_BEHAVIOUR = new JsonQueryOnErrorEmptyArgumentTypeStrategy();
    public static final ArgumentTypeStrategy ARRAY_ELEMENT_ARG = new ArrayElementArgumentTypeStrategy();
    public static final ArgumentTypeStrategy ARRAY_FULLY_COMPARABLE = new ArrayComparableElementArgumentTypeStrategy(StructuredType.StructuredComparison.FULL);
    public static final InputTypeStrategy JSON_OBJECT = InputTypeStrategies.compositeSequence().argument(InputTypeStrategies.symbol(JsonOnNull.class)).finishWithVarying(InputTypeStrategies.repeatingSequence(InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.LITERAL), JSON_ARGUMENT));
    public static final InputTypeStrategy EXTRACT = new ExtractInputTypeStrategy();
    public static final InputTypeStrategy TEMPORAL_OVERLAPS = new TemporalOverlapsInputTypeStrategy();
    public static final InputTypeStrategy ARRAY = new CommonInputTypeStrategy(ConstantArgumentCount.from(1));
    public static final InputTypeStrategy TWO_FULLY_COMPARABLE = InputTypeStrategies.comparable(ConstantArgumentCount.of(2), StructuredType.StructuredComparison.FULL);
    public static final InputTypeStrategy TWO_EQUALS_COMPARABLE = InputTypeStrategies.comparable(ConstantArgumentCount.of(2), StructuredType.StructuredComparison.EQUALS);
    public static final InputTypeStrategy IN = new SubQueryInputTypeStrategy();

    public static InputTypeStrategy windowTimeIndicator(TimestampKind timestampKind) {
        return new WindowTimeIndictorInputTypeStrategy(timestampKind);
    }

    public static InputTypeStrategy windowTimeIndicator() {
        return new WindowTimeIndictorInputTypeStrategy(null);
    }

    private SpecificInputTypeStrategies() {
    }
}

