/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.Collections;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.HllBuffer;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.HyperLogLogPlusPlus;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.XXH64;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.DataTypeUtils;

public class BatchApproxCountDistinctAggFunctions {

    public static class StringApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<BinaryStringData> {
        public StringApproxCountDistinctAggFunction() {
            super((LogicalType)new VarCharType());
        }

        @Override
        long getHashcode(BinaryStringData s) {
            MemorySegment[] segments = s.getSegments();
            if (segments.length == 1) {
                return XXH64.hashUnsafeBytes(segments[0], s.getOffset(), s.getSizeInBytes(), 42L);
            }
            return XXH64.hashUnsafeBytes(MemorySegmentFactory.wrap((byte[])s.toBytes()), 0, s.getSizeInBytes(), 42L);
        }
    }

    public static class TimestampLtzApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<TimestampData> {
        public TimestampLtzApproxCountDistinctAggFunction(LocalZonedTimestampType type) {
            super((LogicalType)type);
        }

        @Override
        long getHashcode(TimestampData value) {
            return XXH64.hashLong(value.getMillisecond(), 42L);
        }
    }

    public static class TimestampApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<TimestampData> {
        public TimestampApproxCountDistinctAggFunction(TimestampType type) {
            super((LogicalType)type);
        }

        @Override
        long getHashcode(TimestampData value) {
            return XXH64.hashLong(value.getMillisecond(), 42L);
        }
    }

    public static class TimeApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Integer> {
        public TimeApproxCountDistinctAggFunction() {
            super((LogicalType)new TimeType());
        }

        @Override
        long getHashcode(Integer value) {
            return XXH64.hashLong(value.intValue(), 42L);
        }
    }

    public static class DateApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Integer> {
        public DateApproxCountDistinctAggFunction() {
            super((LogicalType)new DateType());
        }

        @Override
        long getHashcode(Integer value) {
            return XXH64.hashLong(value.intValue(), 42L);
        }
    }

    public static class ShortApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Short> {
        public ShortApproxCountDistinctAggFunction() {
            super((LogicalType)new SmallIntType());
        }

        @Override
        long getHashcode(Short value) {
            return XXH64.hashInt(value.shortValue(), 42L);
        }
    }

    public static class LongApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Long> {
        public LongApproxCountDistinctAggFunction() {
            super((LogicalType)new BigIntType());
        }

        @Override
        long getHashcode(Long value) {
            return XXH64.hashLong(value, 42L);
        }
    }

    public static class IntApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Integer> {
        public IntApproxCountDistinctAggFunction() {
            super((LogicalType)new IntType());
        }

        @Override
        long getHashcode(Integer value) {
            return XXH64.hashInt(value, 42L);
        }
    }

    public static class FloatApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Float> {
        public FloatApproxCountDistinctAggFunction() {
            super((LogicalType)new FloatType());
        }

        @Override
        long getHashcode(Float value) {
            return XXH64.hashInt(Float.floatToIntBits(this.normalizeFloat(value).floatValue()), 42L);
        }

        private Float normalizeFloat(Float value) {
            if (value.isNaN()) {
                return Float.valueOf(Float.NaN);
            }
            if (value.floatValue() == -0.0f) {
                return Float.valueOf(0.0f);
            }
            return value;
        }
    }

    public static class DoubleApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Double> {
        public DoubleApproxCountDistinctAggFunction() {
            super((LogicalType)new DoubleType());
        }

        @Override
        long getHashcode(Double value) {
            return XXH64.hashLong(Double.doubleToLongBits(this.normalizeDouble(value)), 42L);
        }

        private Double normalizeDouble(Double value) {
            if (value.isNaN()) {
                return Double.NaN;
            }
            if (value == -0.0) {
                return 0.0;
            }
            return value;
        }
    }

    public static class DecimalApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<DecimalData> {
        private final int precision;

        public DecimalApproxCountDistinctAggFunction(DecimalType decimalType) {
            super((LogicalType)decimalType);
            this.precision = decimalType.getPrecision();
        }

        @Override
        long getHashcode(DecimalData d) {
            if (DecimalDataUtils.isByteArrayDecimal(this.precision)) {
                byte[] bytes = d.toBigDecimal().unscaledValue().toByteArray();
                MemorySegment segment = MemorySegmentFactory.wrap((byte[])bytes);
                return XXH64.hashUnsafeBytes(segment, 0, segment.size(), 42L);
            }
            return XXH64.hashLong(d.toUnscaledLong(), 42L);
        }
    }

    public static class ByteApproxCountDistinctAggFunction
    extends ApproxCountDistinctAggFunction<Byte> {
        public ByteApproxCountDistinctAggFunction() {
            super((LogicalType)new TinyIntType());
        }

        @Override
        long getHashcode(Byte value) {
            return XXH64.hashInt(value.byteValue(), 42L);
        }
    }

    public static abstract class ApproxCountDistinctAggFunction<T>
    extends BuiltInAggregateFunction<Long, HllBuffer> {
        private static final Double RELATIVE_SD = 0.01;
        private transient HyperLogLogPlusPlus hll;
        private final transient DataType valueDataType;

        public ApproxCountDistinctAggFunction(LogicalType valueType) {
            this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
        }

        public HllBuffer createAccumulator() {
            this.hll = new HyperLogLogPlusPlus(RELATIVE_SD);
            HllBuffer buffer = new HllBuffer();
            buffer.array = new long[this.hll.getNumWords()];
            this.resetAccumulator(buffer);
            return buffer;
        }

        public void accumulate(HllBuffer buffer, Object input) throws Exception {
            if (input != null) {
                this.hll.updateByHashcode(buffer, this.getHashcode(input));
            }
        }

        abstract long getHashcode(T var1);

        public void merge(HllBuffer buffer, Iterable<HllBuffer> it) throws Exception {
            for (HllBuffer tmpBuffer : it) {
                this.hll.merge(buffer, tmpBuffer);
            }
        }

        public void resetAccumulator(HllBuffer buffer) {
            for (int word = 0; word < this.hll.getNumWords(); ++word) {
                buffer.array[word] = 0L;
            }
        }

        public Long getValue(HllBuffer buffer) {
            return this.hll.query(buffer);
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            return Collections.singletonList(this.valueDataType);
        }

        @Override
        public DataType getAccumulatorDataType() {
            return DataTypes.STRUCTURED(HllBuffer.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"array", (DataType)((DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).notNull()).bridgedTo(long[].class)))});
        }

        @Override
        public DataType getOutputDataType() {
            return DataTypes.BIGINT();
        }
    }
}

