/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;

@PublicEvolving
public abstract class AsyncPredictFunction
extends AsyncTableFunction<RowData> {
    public abstract CompletableFuture<Collection<RowData>> asyncPredict(RowData var1);

    public void eval(CompletableFuture<Collection<RowData>> future, Object ... args) {
        GenericRowData argsData = GenericRowData.of(args);
        this.asyncPredict(argsData).whenComplete((result, exception) -> {
            if (exception != null) {
                future.completeExceptionally(new TableException(String.format("Failed to execute asynchronously prediction with input row %s.", argsData), (Throwable)exception));
                return;
            }
            future.complete((Collection<RowData>)result);
        });
    }
}

