/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.TableFunction;

@PublicEvolving
public abstract class LookupFunction
extends TableFunction<RowData> {
    public abstract Collection<RowData> lookup(RowData var1) throws IOException;

    public final void eval(Object ... keys) {
        GenericRowData keyRow = GenericRowData.of(keys);
        try {
            Collection<RowData> lookup = this.lookup(keyRow);
            if (lookup == null) {
                return;
            }
            lookup.forEach(this::collect);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to lookup values with given key row '%s'", keyRow), e);
        }
    }
}

