/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.ModifyType;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public class SinkModifyOperation
implements ModifyOperation {
    protected final ContextResolvedTable contextResolvedTable;
    private final Map<String, String> staticPartitions;
    private final QueryOperation child;
    private final boolean overwrite;
    private final Map<String, String> dynamicOptions;
    private final ModifyType modifyType;
    @Nullable
    private final int[][] targetColumns;

    public SinkModifyOperation(ContextResolvedTable contextResolvedTable, QueryOperation child) {
        this(contextResolvedTable, child, Collections.emptyMap(), null, false, Collections.emptyMap());
    }

    public SinkModifyOperation(ContextResolvedTable contextResolvedTable, QueryOperation child, int[][] targetColumns, ModifyType modifyType) {
        this(contextResolvedTable, child, Collections.emptyMap(), targetColumns, false, Collections.emptyMap(), modifyType);
    }

    public SinkModifyOperation(ContextResolvedTable contextResolvedTable, QueryOperation child, Map<String, String> staticPartitions, int[][] targetColumns, boolean overwrite, Map<String, String> dynamicOptions) {
        this(contextResolvedTable, child, staticPartitions, targetColumns, overwrite, dynamicOptions, ModifyType.INSERT);
    }

    public SinkModifyOperation(ContextResolvedTable contextResolvedTable, QueryOperation child, Map<String, String> staticPartitions, @Nullable int[][] targetColumns, boolean overwrite, Map<String, String> dynamicOptions, ModifyType modifyType) {
        this.contextResolvedTable = contextResolvedTable;
        this.child = child;
        this.staticPartitions = staticPartitions;
        this.targetColumns = targetColumns;
        this.overwrite = overwrite;
        this.dynamicOptions = dynamicOptions;
        this.modifyType = modifyType;
    }

    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    public Map<String, String> getStaticPartitions() {
        return this.staticPartitions;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isUpdate() {
        return this.modifyType == ModifyType.UPDATE;
    }

    public boolean isDelete() {
        return this.modifyType == ModifyType.DELETE;
    }

    public Map<String, String> getDynamicOptions() {
        return this.dynamicOptions;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    @Nullable
    public int[][] getTargetColumns() {
        return this.targetColumns;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.getContextResolvedTable().getIdentifier().asSummaryString());
        params.put("modifyType", (Object)this.modifyType);
        params.put("staticPartitions", this.staticPartitions);
        params.put("targetColumns", this.targetColumns);
        params.put("overwrite", this.overwrite);
        params.put("dynamicOptions", this.dynamicOptions);
        return OperationUtils.formatWithChildren("CatalogSink", params, Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

