/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.http.server.ServerHttpAsyncRequestControl;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ServletServerHttpAsyncRequestControl
implements ServerHttpAsyncRequestControl,
AsyncListener {
    private static final long NO_TIMEOUT_VALUE = Long.MIN_VALUE;
    private final ServletServerHttpRequest request;
    private final ServletServerHttpResponse response;
    @Nullable
    private AsyncContext asyncContext;
    private final AtomicBoolean asyncCompleted = new AtomicBoolean();

    public ServletServerHttpAsyncRequestControl(ServletServerHttpRequest request, ServletServerHttpResponse response) {
        Assert.notNull((Object)request, "request is required");
        Assert.notNull((Object)response, "response is required");
        Assert.isTrue(request.getServletRequest().isAsyncSupported(), "Async support must be enabled on a servlet and for all filters involved in async request processing. This is done in Java code using the Servlet API or by adding \"<async-supported>true</async-supported>\" to servlet and filter declarations in web.xml.");
        this.request = request;
        this.response = response;
    }

    @Override
    public boolean isStarted() {
        return this.asyncContext != null && this.request.getServletRequest().isAsyncStarted();
    }

    @Override
    public boolean isCompleted() {
        return this.asyncCompleted.get();
    }

    @Override
    public void start() {
        this.start(Long.MIN_VALUE);
    }

    @Override
    public void start(long timeout) {
        Assert.state(!this.isCompleted(), "Async processing has already completed");
        if (this.isStarted()) {
            return;
        }
        HttpServletRequest servletRequest = this.request.getServletRequest();
        HttpServletResponse servletResponse = this.response.getServletResponse();
        this.asyncContext = servletRequest.startAsync((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        this.asyncContext.addListener((AsyncListener)this);
        if (timeout != Long.MIN_VALUE) {
            this.asyncContext.setTimeout(timeout);
        }
    }

    @Override
    public void complete() {
        if (this.asyncContext != null && this.isStarted() && !this.isCompleted()) {
            this.asyncContext.complete();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onTimeout(AsyncEvent event) throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
    }

    public void onComplete(AsyncEvent event) throws IOException {
        this.asyncContext = null;
        this.asyncCompleted.set(true);
    }
}

