/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;

public final class InsertDelta<T>
extends AbstractDelta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.INSERT, original, revised);
    }

    @Override
    protected void applyTo(List<T> target) throws PatchFailedException {
        int position = this.getSource().getPosition();
        List lines = this.getTarget().getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            target.add(position + i2, lines.get(i2));
        }
    }

    @Override
    protected void restore(List<T> target) {
        int position = this.getTarget().getPosition();
        int size = this.getTarget().size();
        for (int i2 = 0; i2 < size; ++i2) {
            target.remove(position);
        }
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getTarget().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new InsertDelta<T>(original, revised);
    }
}

