/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverterToString;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class EntityRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final String entityType;
    private final Long entityIdPrefix;
    private final String entityId;
    private final EntityRowKeyConverter entityRowKeyConverter = new EntityRowKeyConverter();

    public EntityRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, Long entityIdPrefix, String entityId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
        this.entityType = entityType;
        this.entityIdPrefix = entityIdPrefix;
        this.entityId = entityId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Long getEntityIdPrefix() {
        return this.entityIdPrefix;
    }

    public byte[] getRowKey() {
        return this.entityRowKeyConverter.encode(this);
    }

    public static EntityRowKey parseRowKey(byte[] rowKey) {
        return new EntityRowKeyConverter().decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.entityRowKeyConverter.encodeAsString(this);
    }

    public static EntityRowKey parseRowKeyFromString(String encodedRowKey) {
        return new EntityRowKeyConverter().decodeFromString(encodedRowKey);
    }

    private static final class EntityRowKeyConverter
    implements KeyConverter<EntityRowKey>,
    KeyConverterToString<EntityRowKey> {
        private final AppIdKeyConverter appIDKeyConverter = new AppIdKeyConverter();
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0, 8, 0};

        private EntityRowKeyConverter() {
        }

        @Override
        public byte[] encode(EntityRowKey rowKey) {
            byte[] user = Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] flow = Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] first = Separator.QUALIFIERS.join(user, cluster, flow);
            byte[] second = Bytes.toBytes((long)LongConverter.invertLong(rowKey.getFlowRunId()));
            byte[] third = this.appIDKeyConverter.encode(rowKey.getAppId());
            if (rowKey.getEntityType() == null) {
                return Separator.QUALIFIERS.join(first, second, third, Separator.EMPTY_BYTES);
            }
            byte[] entityType = Separator.encode(rowKey.getEntityType(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            if (rowKey.getEntityIdPrefix() == null) {
                return Separator.QUALIFIERS.join(first, second, third, entityType, Separator.EMPTY_BYTES);
            }
            byte[] entityIdPrefix = Bytes.toBytes((long)rowKey.getEntityIdPrefix());
            if (rowKey.getEntityId() == null) {
                return Separator.QUALIFIERS.join(first, second, third, entityType, entityIdPrefix, Separator.EMPTY_BYTES);
            }
            byte[] entityId = Separator.encode(rowKey.getEntityId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] fourth = Separator.QUALIFIERS.join(entityType, entityIdPrefix, entityId);
            return Separator.QUALIFIERS.join(first, second, third, fourth);
        }

        @Override
        public EntityRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 8) {
                throw new IllegalArgumentException("the row key is not valid for an entity");
            }
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long flowRunId = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[3]));
            String appId = this.appIDKeyConverter.decode(rowKeyComponents[4]);
            String entityType = Separator.decode(Bytes.toString((byte[])rowKeyComponents[5]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long entityPrefixId = Bytes.toLong((byte[])rowKeyComponents[6]);
            String entityId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[7]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            return new EntityRowKey(clusterId, userId, flowName, flowRunId, appId, entityType, entityPrefixId, entityId);
        }

        @Override
        public String encodeAsString(EntityRowKey key) {
            if (key.clusterId == null || key.userId == null || key.flowName == null || key.flowRunId == null || key.appId == null || key.entityType == null || key.entityIdPrefix == null || key.entityId == null) {
                throw new IllegalArgumentException();
            }
            return TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{key.clusterId, key.userId, key.flowName, key.flowRunId.toString(), key.appId, key.entityType, key.entityIdPrefix.toString(), key.entityId});
        }

        @Override
        public EntityRowKey decodeFromString(String encodedRowKey) {
            List split = TimelineReaderUtils.split((String)encodedRowKey);
            if (split == null || split.size() != 8) {
                throw new IllegalArgumentException("Invalid row key for entity table.");
            }
            Long flowRunId = Long.valueOf((String)split.get(3));
            Long entityIdPrefix = Long.valueOf((String)split.get(6));
            return new EntityRowKey((String)split.get(0), (String)split.get(1), (String)split.get(2), flowRunId, (String)split.get(4), (String)split.get(5), entityIdPrefix, (String)split.get(7));
        }
    }
}

