/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairQueueACLsManager
extends QueueACLsManager {
    private static final Logger LOG = LoggerFactory.getLogger(FairQueueACLsManager.class);

    public FairQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        super(scheduler, conf);
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses) {
        if (!this.isACLsEnable) {
            return true;
        }
        return this.scheduler.checkAccess(callerUGI, acl, app.getQueue());
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses, String targetQueue) {
        if (!this.isACLsEnable) {
            return true;
        }
        FSQueue queue = ((FairScheduler)this.scheduler).getQueueManager().getQueue(targetQueue);
        if (queue == null) {
            LOG.warn("Target queue " + targetQueue + " does not exist while trying to move " + app.getApplicationId());
            return false;
        }
        return this.scheduler.checkAccess(callerUGI, acl, targetQueue);
    }
}

