/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAclCommands {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    private String path;
    private Configuration conf = null;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.path = this.testFolder.newFile("file").getPath();
    }

    @Test
    public void testGetfaclValidations() throws Exception {
        Assert.assertFalse((String)"getfacl should fail without path", (0 == this.runCommand(new String[]{"-getfacl"}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"getfacl should fail with extra argument", (0 == this.runCommand(new String[]{"-getfacl", this.path, "extraArg"}) ? 1 : 0) != 0);
    }

    @Test
    public void testSetfaclValidations() throws Exception {
        Assert.assertFalse((String)"setfacl should fail without options", (0 == this.runCommand(new String[]{"-setfacl", this.path}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail without options -b, -k, -m, -x or --set", (0 == this.runCommand(new String[]{"-setfacl", "-R", this.path}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail without path", (0 == this.runCommand(new String[]{"-setfacl"}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail without aclSpec", (0 == this.runCommand(new String[]{"-setfacl", "-m", this.path}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail with conflicting options", (0 == this.runCommand(new String[]{"-setfacl", "-m", this.path}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail with extra arguments", (0 == this.runCommand(new String[]{"-setfacl", this.path, "extra"}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail with extra arguments", (0 == this.runCommand(new String[]{"-setfacl", "--set", "default:user::rwx", this.path, "extra"}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail with permissions for -x", (0 == this.runCommand(new String[]{"-setfacl", "-x", "user:user1:rwx", this.path}) ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail ACL spec missing", (0 == this.runCommand(new String[]{"-setfacl", "-m", "", this.path}) ? 1 : 0) != 0);
    }

    @Test
    public void testSetfaclValidationsWithoutPermissions() throws Exception {
        List parsedList = new ArrayList();
        try {
            parsedList = AclEntry.parseAclSpec((String)"user:user1:", (boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((parsedList.size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"setfacl should fail with less arguments", (0 == this.runCommand(new String[]{"-setfacl", "-m", "user:user1:", "/path"}) ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleAclSpecParsing() throws Exception {
        List parsedList = AclEntry.parseAclSpec((String)"group::rwx,user:user1:rwx,user:user2:rw-,group:group1:rw-,default:group:group1:rw-", (boolean)true);
        AclEntry basicAcl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.ALL).build();
        AclEntry user1Acl = new AclEntry.Builder().setType(AclEntryType.USER).setPermission(FsAction.ALL).setName("user1").build();
        AclEntry user2Acl = new AclEntry.Builder().setType(AclEntryType.USER).setPermission(FsAction.READ_WRITE).setName("user2").build();
        AclEntry group1Acl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.READ_WRITE).setName("group1").build();
        AclEntry defaultAcl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.READ_WRITE).setName("group1").setScope(AclEntryScope.DEFAULT).build();
        ArrayList<AclEntry> expectedList = new ArrayList<AclEntry>();
        expectedList.add(basicAcl);
        expectedList.add(user1Acl);
        expectedList.add(user2Acl);
        expectedList.add(group1Acl);
        expectedList.add(defaultAcl);
        Assert.assertEquals((String)"Parsed Acl not correct", expectedList, (Object)parsedList);
    }

    @Test
    public void testMultipleAclSpecParsingWithoutPermissions() throws Exception {
        List parsedList = AclEntry.parseAclSpec((String)"user::,user:user1:,group::,group:group1:,mask::,other::,default:user:user1::,default:mask::", (boolean)false);
        AclEntry owner = new AclEntry.Builder().setType(AclEntryType.USER).build();
        AclEntry namedUser = new AclEntry.Builder().setType(AclEntryType.USER).setName("user1").build();
        AclEntry group = new AclEntry.Builder().setType(AclEntryType.GROUP).build();
        AclEntry namedGroup = new AclEntry.Builder().setType(AclEntryType.GROUP).setName("group1").build();
        AclEntry mask = new AclEntry.Builder().setType(AclEntryType.MASK).build();
        AclEntry other = new AclEntry.Builder().setType(AclEntryType.OTHER).build();
        AclEntry defaultUser = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(AclEntryType.USER).setName("user1").build();
        AclEntry defaultMask = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(AclEntryType.MASK).build();
        ArrayList<AclEntry> expectedList = new ArrayList<AclEntry>();
        expectedList.add(owner);
        expectedList.add(namedUser);
        expectedList.add(group);
        expectedList.add(namedGroup);
        expectedList.add(mask);
        expectedList.add(other);
        expectedList.add(defaultUser);
        expectedList.add(defaultMask);
        Assert.assertEquals((String)"Parsed Acl not correct", expectedList, (Object)parsedList);
    }

    @Test
    public void testLsNoRpcForGetAclStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        conf.setBoolean("stubfs.noRpcForGetAclStatus", true);
        Assert.assertEquals((String)"ls must succeed even if getAclStatus RPC does not exist.", (long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new FsShell(), (String[])new String[]{"-ls", "/"}));
    }

    @Test
    public void testLsAclsUnsupported() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        Assert.assertEquals((String)"ls must succeed even if FileSystem does not implement ACLs.", (long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new FsShell(), (String[])new String[]{"-ls", "/"}));
    }

    private int runCommand(String[] commands) throws Exception {
        return ToolRunner.run((Configuration)this.conf, (Tool)new FsShell(), (String[])commands);
    }

    public static class StubFileSystem
    extends FileSystem {
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public AclStatus getAclStatus(Path path) throws IOException {
            if (this.getConf().getBoolean("stubfs.noRpcForGetAclStatus", false)) {
                throw new RemoteException(RpcNoSuchMethodException.class.getName(), "test exception");
            }
            return super.getAclStatus(path);
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            if (f.isRoot()) {
                return new FileStatus(0L, true, 0, 0L, 0L, f);
            }
            return null;
        }

        public URI getUri() {
            return URI.create("stubfs:///");
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            FsPermission perm = new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE);
            Path path = new Path("/foo");
            FileStatus stat = new FileStatus(1000L, true, 3, 1000L, 0L, 0L, perm, "owner", "group", path);
            return new FileStatus[]{stat};
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public void setWorkingDirectory(Path dir) {
        }
    }
}

