/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb;

import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.NoDocumentFoundException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class CosmosDBDocumentStoreReader<TimelineDoc extends TimelineDocument>
implements DocumentStoreReader<TimelineDoc> {
    private static final Logger LOG = LoggerFactory.getLogger(CosmosDBDocumentStoreReader.class);
    private static final int DEFAULT_DOCUMENTS_SIZE = 1;
    private static AsyncDocumentClient client;
    private final String databaseName;
    private static final String COLLECTION_LINK = "/dbs/%s/colls/%s";
    private static final String SELECT_TOP_FROM_COLLECTION = "SELECT TOP %d * FROM %s c";
    private static final String SELECT_ALL_FROM_COLLECTION = "SELECT  * FROM %s c";
    private static final String SELECT_DISTINCT_TYPES_FROM_COLLECTION = "SELECT  distinct c.type FROM %s c";
    private static final String ENTITY_TYPE_COLUMN = "type";
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final String AND_OPERATOR = " AND ";
    private static final String CONTAINS_FUNC_FOR_ID = " CONTAINS(c.id, \"%s\") ";
    private static final String CONTAINS_FUNC_FOR_TYPE = " CONTAINS(c.type, \"%s\") ";
    private static final String ORDER_BY_CLAUSE = " ORDER BY c.createdTime";
    private static ExecutorService executorService;
    private static Scheduler schedulerForBlockingWork;

    public CosmosDBDocumentStoreReader(Configuration conf) {
        LOG.info("Initializing Cosmos DB DocumentStoreReader...");
        this.databaseName = DocumentStoreUtils.getCosmosDBDatabaseName(conf);
        this.initCosmosDBClient(conf);
    }

    private synchronized void initCosmosDBClient(Configuration conf) {
        if (client == null) {
            LOG.info("Creating Cosmos DB Reader Async Client...");
            client = DocumentStoreUtils.createCosmosDBAsyncClient(conf);
            this.addShutdownHook();
        }
    }

    @Override
    public List<TimelineDoc> readDocumentList(String collectionName, TimelineReaderContext context, Class<TimelineDoc> timelineDocClass, long size) throws NoDocumentFoundException {
        List<TimelineDoc> result = this.queryDocuments(collectionName, context, timelineDocClass, size);
        if (result.size() > 0) {
            return result;
        }
        throw new NoDocumentFoundException("No documents were found while querying Collection : " + collectionName);
    }

    @Override
    public Set<String> fetchEntityTypes(String collectionName, TimelineReaderContext context) {
        StringBuilder queryStrBuilder = new StringBuilder();
        queryStrBuilder.append(String.format(SELECT_DISTINCT_TYPES_FROM_COLLECTION, collectionName));
        String sqlQuery = this.addPredicates(context, collectionName, queryStrBuilder);
        LOG.debug("Querying Collection : {} , with query {}", (Object)collectionName, (Object)sqlQuery);
        return Sets.newHashSet((Iterable)((Iterable)client.queryDocuments(String.format(COLLECTION_LINK, this.databaseName, collectionName), sqlQuery, new FeedOptions()).map(FeedResponse::getResults).concatMap(Observable::from).map(document -> String.valueOf(document.get(ENTITY_TYPE_COLUMN))).toList().subscribeOn(schedulerForBlockingWork).toBlocking().single()));
    }

    @Override
    public TimelineDoc readDocument(String collectionName, TimelineReaderContext context, Class<TimelineDoc> timelineDocClass) throws NoDocumentFoundException {
        List<TimelineDoc> result = this.queryDocuments(collectionName, context, timelineDocClass, 1L);
        if (result.size() > 0) {
            return (TimelineDoc)((TimelineDocument)result.get(0));
        }
        throw new NoDocumentFoundException("No documents were found while querying Collection : " + collectionName);
    }

    private List<TimelineDoc> queryDocuments(String collectionName, TimelineReaderContext context, Class<TimelineDoc> docClass, long maxDocumentsSize) {
        String sqlQuery = this.buildQueryWithPredicates(context, collectionName, maxDocumentsSize);
        LOG.debug("Querying Collection : {} , with query {}", (Object)collectionName, (Object)sqlQuery);
        return (List)client.queryDocuments(String.format(COLLECTION_LINK, this.databaseName, collectionName), sqlQuery, new FeedOptions()).map(FeedResponse::getResults).concatMap(Observable::from).map(document -> {
            TimelineDocument resultDoc = (TimelineDocument)document.toObject(docClass);
            if (resultDoc.getCreatedTime() == 0L && document.getTimestamp() != null) {
                resultDoc.setCreatedTime(document.getTimestamp().getTime());
            }
            return resultDoc;
        }).toList().subscribeOn(schedulerForBlockingWork).toBlocking().single();
    }

    private String buildQueryWithPredicates(TimelineReaderContext context, String collectionName, long size) {
        StringBuilder queryStrBuilder = new StringBuilder();
        if (size == -1L) {
            queryStrBuilder.append(String.format(SELECT_ALL_FROM_COLLECTION, collectionName));
        } else {
            queryStrBuilder.append(String.format(SELECT_TOP_FROM_COLLECTION, size, collectionName));
        }
        return this.addPredicates(context, collectionName, queryStrBuilder);
    }

    @VisibleForTesting
    String addPredicates(TimelineReaderContext context, String collectionName, StringBuilder queryStrBuilder) {
        boolean hasPredicate = false;
        queryStrBuilder.append(WHERE_CLAUSE);
        if (!DocumentStoreUtils.isNullOrEmpty(context.getClusterId())) {
            hasPredicate = true;
            queryStrBuilder.append(String.format(CONTAINS_FUNC_FOR_ID, context.getClusterId()));
        }
        if (!DocumentStoreUtils.isNullOrEmpty(context.getUserId())) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_ID, context.getUserId()));
        }
        if (!DocumentStoreUtils.isNullOrEmpty(context.getFlowName())) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_ID, context.getFlowName()));
        }
        if (!DocumentStoreUtils.isNullOrEmpty(context.getAppId())) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_ID, context.getAppId()));
        }
        if (!DocumentStoreUtils.isNullOrEmpty(context.getEntityId())) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_ID, context.getEntityId()));
        }
        if (context.getFlowRunId() != null) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_ID, context.getFlowRunId()));
        }
        if (!DocumentStoreUtils.isNullOrEmpty(context.getEntityType())) {
            hasPredicate = true;
            queryStrBuilder.append(AND_OPERATOR).append(String.format(CONTAINS_FUNC_FOR_TYPE, context.getEntityType()));
        }
        if (hasPredicate) {
            queryStrBuilder.append(ORDER_BY_CLAUSE);
            LOG.debug("CosmosDB Sql Query with predicates : {}", (Object)queryStrBuilder);
            return queryStrBuilder.toString();
        }
        throw new IllegalArgumentException("The TimelineReaderContext does not have enough information to query documents for Collection : " + collectionName);
    }

    @Override
    public synchronized void close() {
        if (client != null) {
            LOG.info("Closing Cosmos DB Reader Async Client...");
            client.close();
            client = null;
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (executorService != null) {
                executorService.shutdown();
            }
        }));
    }

    static {
        executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() / 2);
        schedulerForBlockingWork = Schedulers.from((Executor)executorService);
    }
}

