/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.util.Iterator;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.MimeHeaders;

class ValuesIterator
implements Iterator<String> {
    int pos;
    int size;
    int currentPos;
    DataChunk next;
    final MimeHeaders headers;
    final String name;

    ValuesIterator(MimeHeaders headers, String name) {
        this.name = name;
        this.headers = headers;
        this.pos = 0;
        this.size = headers.size();
        this.findNext();
    }

    private void findNext() {
        this.next = null;
        while (this.pos < this.size) {
            DataChunk n1 = this.headers.getName(this.pos);
            if (n1.equalsIgnoreCase(this.name)) {
                this.next = this.headers.getValue(this.pos);
                break;
            }
            ++this.pos;
        }
        ++this.pos;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        this.currentPos = this.pos - 1;
        String current = this.next.toString();
        this.findNext();
        return current;
    }

    @Override
    public void remove() {
        if (this.currentPos < 0) {
            throw new IllegalStateException("No current element");
        }
        this.headers.removeHeader(this.currentPos);
        this.pos = this.currentPos;
        this.currentPos = -1;
        --this.size;
        this.findNext();
    }
}

