/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSACLs
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(KMSACLs.class);
    private static final String UNAUTHORIZED_MSG_WITH_KEY = "User:%s not allowed to do '%s' on '%s'";
    private static final String UNAUTHORIZED_MSG_WITHOUT_KEY = "User:%s not allowed to do '%s'";
    public static final String ACL_DEFAULT = "*";
    public static final int RELOADER_SLEEP_MILLIS = 1000;
    public static final EnumSet<Type> INVALIDATE_CACHE_TYPES = EnumSet.of(Type.ROLLOVER, Type.DELETE);
    private volatile Map<Type, AccessControlList> acls;
    private volatile Map<Type, AccessControlList> blacklistedAcls;
    @VisibleForTesting
    volatile Map<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> keyAcls;
    @VisibleForTesting
    volatile Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> defaultKeyAcls = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
    @VisibleForTesting
    volatile Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> whitelistKeyAcls = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
    private ScheduledExecutorService executorService;
    private long lastReload;

    KMSACLs(Configuration conf) {
        if (conf == null) {
            conf = this.loadACLs();
        }
        this.setKMSACLs(conf);
        this.setKeyACLs(conf);
    }

    public KMSACLs() {
        this(null);
    }

    private void setKMSACLs(Configuration conf) {
        HashMap<Type, AccessControlList> tempAcls = new HashMap<Type, AccessControlList>();
        HashMap<Type, AccessControlList> tempBlacklist = new HashMap<Type, AccessControlList>();
        for (Type aclType : Type.values()) {
            String aclStr = conf.get(aclType.getAclConfigKey(), ACL_DEFAULT);
            tempAcls.put(aclType, new AccessControlList(aclStr));
            String blacklistStr = conf.get(aclType.getBlacklistConfigKey());
            if (blacklistStr != null) {
                tempBlacklist.put(aclType, new AccessControlList(blacklistStr));
                LOG.info("'{}' Blacklist '{}'", (Object)aclType, (Object)blacklistStr);
            }
            LOG.info("'{}' ACL '{}'", (Object)aclType, (Object)aclStr);
        }
        this.acls = tempAcls;
        this.blacklistedAcls = tempBlacklist;
    }

    @VisibleForTesting
    void setKeyACLs(Configuration conf) {
        HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> tempKeyAcls = new HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>>();
        Map allKeyACLS = conf.getValByRegex("^key\\.acl\\..+");
        for (Map.Entry keyAcl : allKeyACLS.entrySet()) {
            int keyNameEnds;
            String k = (String)keyAcl.getKey();
            int keyNameStarts = "key.acl.".length();
            if (keyNameStarts >= (keyNameEnds = k.lastIndexOf("."))) {
                LOG.warn("Invalid key name '{}'", (Object)k);
                continue;
            }
            String aclStr = (String)keyAcl.getValue();
            String keyName = k.substring(keyNameStarts, keyNameEnds);
            String keyOp = k.substring(keyNameEnds + 1);
            KeyAuthorizationKeyProvider.KeyOpType aclType = null;
            try {
                aclType = KeyAuthorizationKeyProvider.KeyOpType.valueOf(keyOp);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Invalid key Operation '{}'", (Object)keyOp);
            }
            if (aclType == null) continue;
            HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> aclMap = (HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>)tempKeyAcls.get(keyName);
            if (aclMap == null) {
                aclMap = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
                tempKeyAcls.put(keyName, aclMap);
            }
            aclMap.put(aclType, new AccessControlList(aclStr));
            LOG.info("KEY_NAME '{}' KEY_OP '{}' ACL '{}'", new Object[]{keyName, aclType, aclStr});
        }
        this.keyAcls = tempKeyAcls;
        HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> tempDefaults = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
        HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> tempWhitelists = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
        for (KeyAuthorizationKeyProvider.KeyOpType keyOp : KeyAuthorizationKeyProvider.KeyOpType.values()) {
            this.parseAclsWithPrefix(conf, "default.key.acl.", keyOp, tempDefaults);
            this.parseAclsWithPrefix(conf, "whitelist.key.acl.", keyOp, tempWhitelists);
        }
        this.defaultKeyAcls = tempDefaults;
        this.whitelistKeyAcls = tempWhitelists;
    }

    private void parseAclsWithPrefix(Configuration conf, String prefix, KeyAuthorizationKeyProvider.KeyOpType keyOp, Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> results) {
        String confKey = prefix + (Object)((Object)keyOp);
        String aclStr = conf.get(confKey);
        if (aclStr != null) {
            if (keyOp == KeyAuthorizationKeyProvider.KeyOpType.ALL) {
                LOG.warn("Invalid KEY_OP '{}' for {}, ignoring", (Object)keyOp, (Object)prefix);
            } else {
                if (aclStr.equals(ACL_DEFAULT)) {
                    LOG.info("{} for KEY_OP '{}' is set to '*'", (Object)prefix, (Object)keyOp);
                }
                results.put(keyOp, new AccessControlList(aclStr));
            }
        }
    }

    @Override
    public void run() {
        try {
            if (KMSConfiguration.isACLsFileNewer(this.lastReload)) {
                this.setKMSACLs(this.loadACLs());
                this.setKeyACLs(this.loadACLs());
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format("Could not reload ACLs file: '%s'", ex.toString()), (Throwable)ex);
        }
    }

    public synchronized void startReloader() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.executorService.scheduleAtFixedRate(this, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopReloader() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private Configuration loadACLs() {
        LOG.debug("Loading ACLs file");
        this.lastReload = System.currentTimeMillis();
        Configuration conf = KMSConfiguration.getACLsConf();
        conf.get(Type.CREATE.getAclConfigKey());
        return conf;
    }

    public boolean hasAccess(Type type, UserGroupInformation ugi) {
        boolean access = this.acls.get((Object)type).isUserAllowed(ugi);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking user [{}] for: {} {} ", new Object[]{ugi.getShortUserName(), type.toString(), this.acls.get((Object)type).getAclString()});
        }
        if (access) {
            AccessControlList blacklist = this.blacklistedAcls.get((Object)type);
            boolean bl = access = blacklist == null || !blacklist.isUserInList(ugi);
            if (LOG.isDebugEnabled()) {
                if (blacklist == null) {
                    LOG.debug("No blacklist for {}", (Object)type.toString());
                } else if (access) {
                    LOG.debug("user is not in {}", (Object)blacklist.getAclString());
                } else {
                    LOG.debug("user is in {}", (Object)blacklist.getAclString());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("User: [{}], Type: {} Result: {}", new Object[]{ugi.getShortUserName(), type.toString(), access});
        }
        return access;
    }

    public void assertAccess(Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key) throws AccessControlException {
        if (!KMSWebApp.getACLs().hasAccess(aclType, ugi)) {
            KMSWebApp.getUnauthorizedCallsMeter().mark();
            KMSWebApp.getKMSAudit().unauthorized(ugi, operation, key);
            throw new AuthorizationException(String.format(key != null ? UNAUTHORIZED_MSG_WITH_KEY : UNAUTHORIZED_MSG_WITHOUT_KEY, new Object[]{ugi.getShortUserName(), operation, key}));
        }
    }

    public void assertAccess(EnumSet<Type> aclTypes, UserGroupInformation ugi, KMS.KMSOp operation, String key) throws AccessControlException {
        boolean accessAllowed = false;
        for (Type type : aclTypes) {
            if (!KMSWebApp.getACLs().hasAccess(type, ugi)) continue;
            accessAllowed = true;
            break;
        }
        if (!accessAllowed) {
            KMSWebApp.getUnauthorizedCallsMeter().mark();
            KMSWebApp.getKMSAudit().unauthorized(ugi, operation, key);
            throw new AuthorizationException(String.format(key != null ? UNAUTHORIZED_MSG_WITH_KEY : UNAUTHORIZED_MSG_WITHOUT_KEY, new Object[]{ugi.getShortUserName(), operation, key}));
        }
    }

    @Override
    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        boolean access;
        boolean bl = access = this.checkKeyAccess(keyName, ugi, opType) || this.checkKeyAccess(this.whitelistKeyAcls, ugi, opType);
        if (!access) {
            KMSWebApp.getKMSAudit().unauthorized(ugi, opType, keyName);
        }
        return access;
    }

    private boolean checkKeyAccess(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> keyAcl = (Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>)this.keyAcls.get(keyName);
        if (keyAcl == null) {
            LOG.debug("Key: {} has no ACLs defined, using defaults.", (Object)keyName);
            keyAcl = this.defaultKeyAcls;
        }
        boolean access = this.checkKeyAccess(keyAcl, ugi, opType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("User: [{}], OpType: {}, KeyName: {} Result: {}", new Object[]{ugi.getShortUserName(), opType.toString(), keyName, access});
        }
        return access;
    }

    private boolean checkKeyAccess(Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> keyAcl, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        AccessControlList acl = keyAcl.get((Object)opType);
        if (acl == null) {
            LOG.debug("No ACL available for key, denying access for {}", (Object)opType);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking user [{}] for: {}: {}", new Object[]{ugi.getShortUserName(), opType.toString(), acl.getAclString()});
        }
        return acl.isUserAllowed(ugi);
    }

    @Override
    public boolean isACLPresent(String keyName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        return this.keyAcls.containsKey(keyName) || this.defaultKeyAcls.containsKey((Object)opType) || this.whitelistKeyAcls.containsKey((Object)opType);
    }

    @VisibleForTesting
    void forceNextReloadForTesting() {
        this.lastReload = 0L;
    }

    public static enum Type {
        CREATE,
        DELETE,
        ROLLOVER,
        GET,
        GET_KEYS,
        GET_METADATA,
        SET_KEY_MATERIAL,
        GENERATE_EEK,
        DECRYPT_EEK;


        public String getAclConfigKey() {
            return "hadoop.kms.acl." + this.toString();
        }

        public String getBlacklistConfigKey() {
            return "hadoop.kms.blacklist." + this.toString();
        }
    }
}

