/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.datalake.store.QueryParams;
import com.microsoft.azure.datalake.store.oauth2.DeviceCodeCallback;
import com.microsoft.azure.datalake.store.oauth2.DeviceCodeInfo;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeviceCodeTokenProviderHelper {
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store.oauth2.DeviceCodeTokenProvider");
    private static final String defaultAppId = "c8964590-6116-42e6-8a29-ec0865dff3d5";
    private static final String resource = "https://datalake.azure.net/";
    private static final String deviceCodeUrl = "https://login.microsoftonline.com/common/oauth2/devicecode";
    private static final String tokenUrl = "https://login.microsoftonline.com/common/oauth2/token";

    DeviceCodeTokenProviderHelper() {
    }

    public static RefreshTokenInfo getRefreshToken(String appId, DeviceCodeCallback callback) throws IOException {
        if (appId == null) {
            appId = defaultAppId;
        }
        if (callback == null) {
            callback = DeviceCodeCallback.getDefaultInstance();
        }
        DeviceCodeInfo dcInfo = DeviceCodeTokenProviderHelper.getDeviceCodeInfo(appId);
        log.debug("AADToken: obtained device code, prompting user to login through browser");
        callback.showDeviceCodeMessage(dcInfo);
        RefreshTokenInfo token = DeviceCodeTokenProviderHelper.getTokenFromDeviceCode(dcInfo);
        log.debug("AADToken: obtained refresh token from device-code based user login");
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeviceCodeInfo getDeviceCodeInfo(String appId) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        qp.add("client_id", appId);
        String queryString = qp.serialize();
        URL url = new URL("https://login.microsoftonline.com/common/oauth2/devicecode?" + queryString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        DeviceCodeInfo dcInfo = new DeviceCodeInfo();
        dcInfo.clientId = appId;
        int httpResponseCode = conn.getResponseCode();
        if (httpResponseCode == 200) {
            try (InputStream httpResponseStream = conn.getInputStream();){
                int expiryPeriod = 0;
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(httpResponseStream);
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("user_code")) {
                            dcInfo.usercode = fieldValue;
                        }
                        if (fieldName.equals("device_code")) {
                            dcInfo.devicecode = fieldValue;
                        }
                        if (fieldName.equals("verification_url")) {
                            dcInfo.verificationUrl = fieldValue;
                        }
                        if (fieldName.equals("message")) {
                            dcInfo.message = fieldValue;
                        }
                        if (fieldName.equals("expires_in")) {
                            expiryPeriod = Integer.parseInt(fieldValue);
                        }
                        if (fieldName.equals("interval")) {
                            dcInfo.pollingInterval = Integer.parseInt(fieldValue);
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                long expiry = System.currentTimeMillis();
                dcInfo.expiry = new Date(expiry += (long)expiryPeriod * 1000L);
            }
        } else {
            String message = "Failed to get device code from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage();
            log.debug(message);
            throw new IOException(message);
        }
        log.debug("Obtained device code from AAD: " + dcInfo.usercode);
        return dcInfo;
    }

    private static RefreshTokenInfo getTokenFromDeviceCode(DeviceCodeInfo dcInfo) throws IOException {
        RefreshTokenInfo refreshToken = null;
        int sleepDuration = (dcInfo.pollingInterval + 1) * 1000;
        while (dcInfo.expiry.getTime() > new Date().getTime() && refreshToken == null) {
            try {
                Thread.sleep(sleepDuration);
                refreshToken = DeviceCodeTokenProviderHelper.getTokenInternal(dcInfo.devicecode, dcInfo.clientId);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                log.debug("Exception getting token from device code " + ex.toString());
                throw ex;
            }
        }
        return refreshToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RefreshTokenInfo getTokenInternal(String deviceCode, String clientId) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        qp.add("client_id", clientId);
        qp.add("grant_type", "device_code");
        qp.add("code", deviceCode);
        String bodyString = qp.serialize();
        URL url = new URL(tokenUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.getOutputStream().write(bodyString.getBytes("UTF-8"));
        RefreshTokenInfo token = new RefreshTokenInfo();
        String tokentype = null;
        String scope = null;
        int httpResponseCode = conn.getResponseCode();
        if (httpResponseCode == 200) {
            try (InputStream httpResponseStream = conn.getInputStream();){
                int expiryPeriod = 0;
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(httpResponseStream);
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("token_type")) {
                            tokentype = fieldValue;
                        }
                        if (fieldName.equals("scope")) {
                            scope = fieldValue;
                        }
                        if (fieldName.equals("expires_in")) {
                            expiryPeriod = Integer.parseInt(fieldValue);
                        }
                        if (fieldName.equals("access_token")) {
                            token.accessToken = fieldValue;
                        }
                        if (fieldName.equals("refresh_token")) {
                            token.refreshToken = fieldValue;
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                if (!"Bearer".equals(tokentype) || !"user_impersonation".equals(scope)) {
                    throw new IOException("not sure what kind of token we got");
                }
                long expiry = System.currentTimeMillis();
                token.accessTokenExpiry = new Date(expiry += (long)expiryPeriod * 1000L);
                RefreshTokenInfo refreshTokenInfo = token;
                return refreshTokenInfo;
            }
        }
        if (httpResponseCode == 400) {
            try (InputStream httpResponseStream = conn.getErrorStream();){
                String error = null;
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(httpResponseStream);
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("error")) {
                            error = fieldValue;
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                if (!"authorization_pending".equals(error)) {
                    String message = "Failed to acquire token from AzureAD. Http response: " + httpResponseCode + " Error: " + error;
                    log.debug(message);
                    throw new IOException(message);
                }
                log.debug("polled AAD for token, got authorization_pending (still waiting for user to complete login)");
            }
        } else {
            String message = "Failed to acquire token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage();
            log.debug(message);
            throw new IOException(message);
        }
        return null;
    }

    private static void printDeviceCodeInfo(DeviceCodeInfo dcInfo) {
        System.out.println("UserCode: " + dcInfo.usercode);
        System.out.println("VerificationUrl: " + dcInfo.verificationUrl);
        System.out.println("Polling Interval: " + dcInfo.devicecode);
        System.out.println("Expires: " + dcInfo.expiry);
        System.out.println("Message: " + dcInfo.message);
        System.out.println("Devicecode: " + dcInfo.devicecode);
        System.out.println();
    }
}

