/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.CSES3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.CSEUtils;
import org.apache.hadoop.util.ReflectionUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class CSEV1CompatibleS3AFileSystemOperations
extends CSES3AFileSystemOperations {
    @Override
    public ResponseInputStream<GetObjectResponse> getObject(S3AStore store, GetObjectRequest request, RequestFactory factory) throws IOException {
        boolean isEncrypted = CSEUtils.isObjectEncrypted(store, request.key());
        return isEncrypted ? store.getOrCreateS3Client().getObject(request) : store.getOrCreateUnencryptedS3Client().getObject(request);
    }

    @Override
    public S3ClientFactory getUnencryptedS3ClientFactory(Configuration conf) {
        Class s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
        return (S3ClientFactory)ReflectionUtils.newInstance((Class)s3ClientFactoryClass, (Configuration)conf);
    }

    @Override
    public long getS3ObjectSize(String key, long length, S3AStore store, HeadObjectResponse response) throws IOException {
        return CSEUtils.getUnencryptedObjectLength(store, key, length, response);
    }
}

