/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import com.sun.jersey.api.client.Client;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NodeLabelsBlock
extends RouterBlock {
    private Router router;

    @Inject
    public NodeLabelsBlock(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        boolean isEnabled = this.isYarnFederationEnabled();
        String subClusterName = this.$("node.subcluster");
        NodeLabelsInfo nodeLabelsInfo = null;
        nodeLabelsInfo = StringUtils.isNotEmpty((CharSequence)subClusterName) ? this.getSubClusterNodeLabelsInfo(subClusterName) : this.getYarnFederationNodeLabelsInfo(isEnabled);
        this.initYarnFederationNodeLabelsOfCluster(nodeLabelsInfo, html);
    }

    private NodeLabelsInfo getSubClusterNodeLabelsInfo(String subCluster) {
        try {
            SubClusterId subClusterId = SubClusterId.newInstance((String)subCluster);
            FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)this.router.getConfig());
            SubClusterInfo subClusterInfo = facade.getSubCluster(subClusterId);
            if (subClusterInfo != null) {
                String webAddress = subClusterInfo.getRMWebServiceAddress();
                String herfWebAppAddress = "";
                if (webAddress != null && !webAddress.isEmpty()) {
                    herfWebAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.router.getConfig()) + webAddress;
                    return this.getSubClusterNodeLabelsByWebAddress(herfWebAppAddress);
                }
            }
        }
        catch (Exception e) {
            LOG.error("get NodeLabelsInfo From SubCluster = {} error.", (Object)subCluster, (Object)e);
        }
        return null;
    }

    private NodeLabelsInfo getYarnFederationNodeLabelsInfo(boolean isEnabled) {
        Configuration config = this.router.getConfig();
        String webAddress = isEnabled ? WebAppUtils.getRouterWebAppURLWithScheme((Configuration)config) : WebAppUtils.getRMWebAppURLWithScheme((Configuration)config);
        return this.getSubClusterNodeLabelsByWebAddress(webAddress);
    }

    private NodeLabelsInfo getSubClusterNodeLabelsByWebAddress(String webAddress) {
        Configuration conf = this.router.getConfig();
        Client client = RouterWebServiceUtil.createJerseyClient(conf);
        NodeLabelsInfo nodes = RouterWebServiceUtil.genericForward(webAddress, null, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-rm-node-labels", null, null, conf, client);
        client.destroy();
        return nodes;
    }

    private void initYarnFederationNodeLabelsOfCluster(NodeLabelsInfo nodeLabelsInfo, HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodelabels").thead().tr().th(".name", "Label Name").th(".type", "Label Type").th(".numOfActiveNMs", "Num Of Active NMs").th(".totalResource", "Total Resource").__()).__()).tbody();
        if (nodeLabelsInfo != null) {
            for (NodeLabelInfo info : nodeLabelsInfo.getNodeLabelsInfo()) {
                Hamlet.TR row = tbody.tr().td(info.getName().isEmpty() ? "<DEFAULT_PARTITION>" : info.getName());
                String type = info.getExclusivity() ? "Exclusive Partition" : "Non Exclusive Partition";
                row = row.td(type);
                int nActiveNMs = info.getActiveNMs();
                row = nActiveNMs > 0 ? (Hamlet.TR)row.td().a(this.url(new String[]{"nodes", "?node.label=" + info.getName()}), String.valueOf(nActiveNMs)).__() : row.td(String.valueOf(nActiveNMs));
                PartitionInfo partitionInfo = info.getPartitionInfo();
                ResourceInfo available = partitionInfo.getResourceAvailable();
                row.td(available.toFormattedString()).__();
            }
        }
        ((Hamlet.TABLE)tbody.__()).__();
    }
}

