/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class WeightedRandomRouterPolicy
extends AbstractRouterPolicy {
    @Override
    protected SubClusterId chooseSubCluster(String queue, Map<SubClusterId, SubClusterInfo> preSelectSubclusters) throws YarnException {
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        ArrayList<Float> weightList = new ArrayList<Float>();
        ArrayList<SubClusterId> scIdList = new ArrayList<SubClusterId>();
        for (Map.Entry<SubClusterIdInfo, Float> entry : weights.entrySet()) {
            SubClusterIdInfo key = entry.getKey();
            if (key == null || !preSelectSubclusters.containsKey(key.toId())) continue;
            weightList.add(entry.getValue());
            scIdList.add(key.toId());
        }
        int pickedIndex = FederationPolicyUtils.getWeightedRandom(weightList);
        if (pickedIndex == -1) {
            throw new FederationPolicyException("No positive weight found on active subclusters");
        }
        return (SubClusterId)scIdList.get(pickedIndex);
    }
}

