/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RouterStoreImpl
extends RouterStore {
    public RouterStoreImpl(StateStoreDriver driver) {
        super(driver);
    }

    @Override
    public GetRouterRegistrationResponse getRouterRegistration(GetRouterRegistrationRequest request) throws IOException {
        RouterState partial = RouterState.newInstance();
        partial.setAddress(request.getRouterId());
        Query<RouterState> query = new Query<RouterState>(partial);
        RouterState record = this.getDriver().get(this.getRecordClass(), query);
        if (record != null) {
            this.overrideExpiredRecord(record);
        }
        GetRouterRegistrationResponse response = GetRouterRegistrationResponse.newInstance();
        response.setRouter(record);
        return response;
    }

    @Override
    public GetRouterRegistrationsResponse getRouterRegistrations(GetRouterRegistrationsRequest request) throws IOException {
        QueryResult recordsAndTimeStamp = this.getCachedRecordsAndTimeStamp();
        List<RouterState> records = recordsAndTimeStamp.getRecords();
        long timestamp = recordsAndTimeStamp.getTimestamp();
        GetRouterRegistrationsResponse response = GetRouterRegistrationsResponse.newInstance();
        response.setRouters(records);
        response.setTimestamp(timestamp);
        return response;
    }

    @Override
    public RouterHeartbeatResponse routerHeartbeat(RouterHeartbeatRequest request) throws IOException {
        RouterState record = request.getRouter();
        boolean status = this.getDriver().put(record, true, false);
        RouterHeartbeatResponse response = RouterHeartbeatResponse.newInstance(status);
        return response;
    }
}

