/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.schema.AttributeType;

public class SortKey {
    private String attributeTypeOid;
    private AttributeType attributeType;
    private String matchingRuleId;
    private boolean reverseOrder;

    public SortKey(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.matchingRuleId = attributeType.getOrderingOid();
        this.reverseOrder = false;
    }

    public SortKey(String attributeTypeOid) {
        this.attributeTypeOid = attributeTypeOid;
        this.matchingRuleId = null;
        this.reverseOrder = false;
    }

    public SortKey(AttributeType attributeType, String matchingRuleId) {
        this.attributeType = attributeType;
        this.matchingRuleId = matchingRuleId;
        this.reverseOrder = false;
    }

    public SortKey(String attributeTypeOid, String matchingRuleId) {
        this.attributeTypeOid = attributeTypeOid;
        this.matchingRuleId = matchingRuleId;
        this.reverseOrder = false;
    }

    public SortKey(AttributeType attributeType, String matchingRuleId, boolean reverseOrder) {
        this.attributeType = attributeType;
        this.matchingRuleId = matchingRuleId;
        this.reverseOrder = reverseOrder;
    }

    public SortKey(String attributeTypeOid, String matchingRuleId, boolean reverseOrder) {
        this.attributeTypeOid = attributeTypeOid;
        this.matchingRuleId = matchingRuleId;
        this.reverseOrder = reverseOrder;
    }

    public SortKey(AttributeType attributeType, boolean reverseOrder) {
        this.attributeType = attributeType;
        this.matchingRuleId = attributeType.getOrderingOid();
        this.reverseOrder = reverseOrder;
    }

    public SortKey(String attributeTypeOid, boolean reverseOrder) {
        this.attributeTypeOid = attributeTypeOid;
        this.reverseOrder = reverseOrder;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.attributeTypeOid = attributeType.getOid();
    }

    public String getAttributeTypeOid() {
        return this.attributeTypeOid;
    }

    public void setAttributeType(String attributeTypeOid) {
        this.attributeTypeOid = attributeTypeOid;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public void setMatchingRuleId(String matchingRuleId) {
        this.matchingRuleId = matchingRuleId;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SortKey : [");
        if (this.attributeType != null) {
            sb.append(this.attributeType.getName()).append(',');
            sb.append(this.matchingRuleId);
        } else {
            sb.append(this.attributeTypeOid);
            if (this.matchingRuleId != null) {
                sb.append(", ").append(this.matchingRuleId);
            }
        }
        if (this.reverseOrder) {
            sb.append(", reverse");
        }
        sb.append(']');
        return sb.toString();
    }
}

