/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationQueue
extends LeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ReservationQueue.class);
    private PlanQueue parent;

    public ReservationQueue(CapacitySchedulerContext cs, String queueName, PlanQueue parent) throws IOException {
        super(cs, queueName, parent, null);
        this.updateQuotas(parent.getUserLimitForReservation(), parent.getUserLimitFactor(), parent.getMaxApplicationsForReservations(), parent.getMaxApplicationsPerUserForReservation());
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            if (!(newlyParsedQueue instanceof ReservationQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            super.reinitialize(newlyParsedQueue, clusterResource);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            this.updateQuotas(this.parent.getUserLimitForReservation(), this.parent.getUserLimitFactor(), this.parent.getMaxApplicationsForReservations(), this.parent.getMaxApplicationsPerUserForReservation());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntitlement(QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            float capacity = entitlement.getCapacity();
            if (capacity < 0.0f || capacity > 1.0f) {
                throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
            }
            this.setCapacity(capacity);
            this.setAbsoluteCapacity(this.getParent().getAbsoluteCapacity() * this.getCapacity());
            this.setMaxCapacity(entitlement.getMaxCapacity());
            if (LOG.isDebugEnabled()) {
                LOG.debug("successfully changed to " + capacity + " for queue " + this.getQueueName());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateQuotas(int userLimit, float userLimitFactor, int maxAppsForReservation, int maxAppsPerUserForReservation) {
        this.setUserLimit(userLimit);
        this.setUserLimitFactor(userLimitFactor);
        this.setMaxApplications(maxAppsForReservation);
        this.maxApplicationsPerUser = maxAppsPerUserForReservation;
    }

    @Override
    protected void setupConfigurableCapacities() {
        CSQueueUtils.updateAndCheckCapacitiesByLabel(this.getQueuePath(), this.queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }
}

