/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.mob.DefaultMobStoreCompactor;
import org.apache.hadoop.hbase.mob.DefaultMobStoreFlusher;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MobStoreEngine
extends DefaultStoreEngine {
    public static final String MOB_COMPACTOR_CLASS_KEY = "hbase.hstore.mobengine.compactor.class";

    @Override
    protected void createStoreFlusher(Configuration conf, HStore store) throws IOException {
        this.storeFlusher = new DefaultMobStoreFlusher(conf, store);
    }

    @Override
    protected void createCompactor(Configuration conf, HStore store) throws IOException {
        String className = conf.get(MOB_COMPACTOR_CLASS_KEY, DefaultMobStoreCompactor.class.getName());
        try {
            this.compactor = (Compactor)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, HStore.class}, new Object[]{conf, store});
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to load configured compactor '" + className + "'", e);
        }
    }
}

