/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableQuotaSnapshotStore
implements QuotaSnapshotStore<TableName> {
    private static final Logger LOG = LoggerFactory.getLogger(TableQuotaSnapshotStore.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rlock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock wlock = this.lock.writeLock();
    private final Connection conn;
    private final QuotaObserverChore chore;
    private Map<RegionInfo, Long> regionUsage;

    public TableQuotaSnapshotStore(Connection conn, QuotaObserverChore chore, Map<RegionInfo, Long> regionUsage) {
        this.conn = Objects.requireNonNull(conn);
        this.chore = Objects.requireNonNull(chore);
        this.regionUsage = Objects.requireNonNull(regionUsage);
    }

    @Override
    public QuotaProtos.SpaceQuota getSpaceQuota(TableName subject) throws IOException {
        QuotaProtos.Quotas quotas = this.getQuotaForTable(subject);
        if (quotas != null && quotas.hasSpace()) {
            return quotas.getSpace();
        }
        return null;
    }

    QuotaProtos.Quotas getQuotaForTable(TableName table) throws IOException {
        return QuotaTableUtil.getTableQuota(this.conn, table);
    }

    @Override
    public SpaceQuotaSnapshot getCurrentState(TableName table) {
        return this.chore.getTableQuotaSnapshot(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceQuotaSnapshot getTargetState(TableName table, QuotaProtos.SpaceQuota spaceQuota) throws IOException {
        this.rlock.lock();
        try {
            long sizeLimitInBytes = spaceQuota.getSoftLimit();
            long sum = 0L;
            for (Map.Entry<RegionInfo, Long> entry : this.filterBySubject(table)) {
                sum += entry.getValue().longValue();
            }
            SpaceQuotaSnapshot.SpaceQuotaStatus status = (sum += this.getSnapshotSizesForTable(table)) <= sizeLimitInBytes ? SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation() : new SpaceQuotaSnapshot.SpaceQuotaStatus(ProtobufUtil.toViolationPolicy(spaceQuota.getViolationPolicy()));
            SpaceQuotaSnapshot spaceQuotaSnapshot = new SpaceQuotaSnapshot(status, sum, sizeLimitInBytes);
            return spaceQuotaSnapshot;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSnapshotSizesForTable(TableName tn) throws IOException {
        Throwable throwable = null;
        try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            Scan s2 = QuotaTableUtil.createScanForSpaceSnapshotSizes(tn);
            ResultScanner rs = quotaTable.getScanner(s2);
            try {
                long size = 0L;
                for (Result result : rs) {
                    CellScanner cs = result.cellScanner();
                    while (cs.advance()) {
                        Cell current = cs.current();
                        try {
                            long snapshotSize = QuotaTableUtil.parseSnapshotSize(current);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Saw snapshot size of " + snapshotSize + " for " + current);
                            }
                            size += snapshotSize;
                        }
                        catch (InvalidProtocolBufferException e) {
                            LOG.warn("Failed to parse snapshot size from cell: " + current);
                        }
                    }
                }
                long l = size;
                if (null != rs) {
                    rs.close();
                }
                return l;
            }
            catch (Throwable throwable2) {
                try {
                    if (null != rs) {
                        rs.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    @Override
    public Iterable<Map.Entry<RegionInfo, Long>> filterBySubject(TableName table) {
        this.rlock.lock();
        try {
            Iterable iterable = this.regionUsage.entrySet().stream().filter(entry -> table.equals(((RegionInfo)entry.getKey()).getTable())).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public void setCurrentState(TableName table, SpaceQuotaSnapshot snapshot) {
        this.chore.setTableQuotaSnapshot(table, snapshot);
    }

    @Override
    public void setRegionUsage(Map<RegionInfo, Long> regionUsage) {
        this.wlock.lock();
        try {
            this.regionUsage = Objects.requireNonNull(regionUsage);
        }
        finally {
            this.wlock.unlock();
        }
    }
}

