/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToByteEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CryptoAESWrapHandler
extends MessageToByteEncoder<ByteBuf> {
    private final CryptoAES cryptoAES;

    public CryptoAESWrapHandler(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        byte[] wrapperBytes = this.cryptoAES.wrap(bytes, 0, bytes.length);
        out.ensureWritable(4 + wrapperBytes.length);
        out.writeInt(wrapperBytes.length);
        out.writeBytes(wrapperBytes);
    }
}

