/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.util.Bytes;

public class HTestConst {
    public static final String DEFAULT_TABLE_STR = "MyTestTable";
    public static final byte[] DEFAULT_TABLE_BYTES = Bytes.toBytes((String)"MyTestTable");
    public static final TableName DEFAULT_TABLE = TableName.valueOf((byte[])DEFAULT_TABLE_BYTES);
    public static final String DEFAULT_CF_STR = "MyDefaultCF";
    public static final byte[] DEFAULT_CF_BYTES = Bytes.toBytes((String)"MyDefaultCF");
    public static final Set<String> DEFAULT_CF_STR_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("MyDefaultCF")));
    public static final String DEFAULT_ROW_STR = "MyTestRow";
    public static final byte[] DEFAULT_ROW_BYTES = Bytes.toBytes((String)"MyTestRow");
    public static final String DEFAULT_QUALIFIER_STR = "MyColumnQualifier";
    public static final byte[] DEFAULT_QUALIFIER_BYTES = Bytes.toBytes((String)"MyColumnQualifier");
    public static String DEFAULT_VALUE_STR = "MyTestValue";
    public static byte[] DEFAULT_VALUE_BYTES = Bytes.toBytes((String)DEFAULT_VALUE_STR);
    private static final char FIRST_CHAR = 'a';
    private static final char LAST_CHAR = 'z';
    private static final byte[] START_KEY_BYTES = new byte[]{97, 97, 97};

    private HTestConst() {
    }

    public static byte[][] makeNAscii(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    public static long addContent(Region r, byte[] columnFamily, byte[] column) throws IOException {
        byte[] startKey = r.getRegionInfo().getStartKey();
        byte[] endKey = r.getRegionInfo().getEndKey();
        byte[] startKeyBytes = startKey;
        if (startKeyBytes == null || startKeyBytes.length == 0) {
            startKeyBytes = START_KEY_BYTES;
        }
        return HTestConst.addContent(new RegionAsTable(r), Bytes.toString((byte[])columnFamily), Bytes.toString((byte[])column), startKeyBytes, endKey, -1L);
    }

    public static long addContent(Region r, byte[] columnFamily) throws IOException {
        return HTestConst.addContent(r, columnFamily, null);
    }

    public static long addContent(Table updater, String columnFamily) throws IOException {
        return HTestConst.addContent(updater, columnFamily, START_KEY_BYTES, null);
    }

    public static long addContent(Table updater, String family, String column) throws IOException {
        return HTestConst.addContent(updater, family, column, START_KEY_BYTES, null);
    }

    public static long addContent(Table updater, String columnFamily, byte[] startKeyBytes, byte[] endKey) throws IOException {
        return HTestConst.addContent(updater, columnFamily, null, startKeyBytes, endKey, -1L);
    }

    public static long addContent(Table updater, String family, String column, byte[] startKeyBytes, byte[] endKey) throws IOException {
        return HTestConst.addContent(updater, family, column, startKeyBytes, endKey, -1L);
    }

    public static long addContent(Table updater, String columnFamily, String column, byte[] startKeyBytes, byte[] endKey, long ts) throws IOException {
        long count = 0L;
        int secondCharStart = startKeyBytes[1];
        int thirdCharStart = startKeyBytes[2];
        block0: for (char c = (char)startKeyBytes[0]; c <= 'z'; c = (char)(c + '\u0001')) {
            for (int d = secondCharStart; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = thirdCharStart; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] t = new byte[]{(byte)c, (byte)d, (byte)e};
                    if (endKey != null && endKey.length > 0 && Bytes.compareTo((byte[])endKey, (byte[])t) <= 0) break block0;
                    Put put = ts != -1L ? new Put(t, ts) : new Put(t);
                    StringBuilder sb = new StringBuilder();
                    if (column != null && column.contains(":")) {
                        sb.append(column);
                    } else if (columnFamily != null) {
                        sb.append(columnFamily);
                        if (!columnFamily.endsWith(":")) {
                            sb.append(":");
                        }
                        if (column != null) {
                            sb.append(column);
                        }
                    }
                    byte[][] split = CellUtil.parseColumn((byte[])Bytes.toBytes((String)sb.toString()));
                    if (split.length == 1) {
                        byte[] qualifier = new byte[]{};
                        put.addColumn(split[0], qualifier, t);
                    } else {
                        put.addColumn(split[0], split[1], t);
                    }
                    put.setDurability(Durability.SKIP_WAL);
                    updater.put(put);
                    ++count;
                }
                thirdCharStart = 97;
            }
            secondCharStart = 97;
        }
        return count;
    }
}

