/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterDryRunBalancer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterDryRunBalancer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");

    @After
    public void shutdown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDryRunBalancer() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        int numRegions = 100;
        int regionsPerRs = numRegions / 2;
        TableName tableName = this.createTable("testDryRunBalancer", numRegions);
        HMaster master = (HMaster)Mockito.spy((Object)TEST_UTIL.getHBaseCluster().getMaster());
        master.balanceSwitch(false);
        Assert.assertFalse((boolean)master.isBalancerOn());
        HRegionServer biasedServer = this.unbalance(master, tableName);
        BalanceResponse response = master.balance(BalanceRequest.newBuilder().setDryRun(true).build());
        Assert.assertTrue((boolean)response.isBalancerRan());
        Assert.assertTrue((response.getMovesCalculated() >= regionsPerRs - 1 && response.getMovesCalculated() <= regionsPerRs + 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)response.getMovesExecuted());
        ((HMaster)Mockito.verify((Object)master, (VerificationMode)Mockito.never())).executeRegionPlansWithThrottling(Mockito.anyList());
        this.assertServerContainsAllRegions(biasedServer.getServerName(), tableName);
        TEST_UTIL.deleteTable(tableName);
    }

    private TableName createTable(String table, int numRegions) throws IOException {
        TableName tableName = TableName.valueOf((String)table);
        TEST_UTIL.createMultiRegionTable(tableName, FAMILYNAME, numRegions);
        return tableName;
    }

    private HRegionServer unbalance(HMaster master, TableName tableName) throws Exception {
        this.waitForRegionsToSettle(master);
        HRegionServer biasedServer = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        for (RegionInfo regionInfo : TEST_UTIL.getAdmin().getRegions(tableName)) {
            master.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)biasedServer.getServerName().getServerName()));
        }
        this.waitForRegionsToSettle(master);
        this.assertServerContainsAllRegions(biasedServer.getServerName(), tableName);
        return biasedServer;
    }

    private void assertServerContainsAllRegions(ServerName serverName, TableName tableName) throws IOException {
        int numRegions = TEST_UTIL.getAdmin().getRegions(tableName).size();
        Assert.assertEquals((long)numRegions, (long)TEST_UTIL.getMiniHBaseCluster().getRegionServer(serverName).getRegions(tableName).size());
    }

    private void waitForRegionsToSettle(HMaster master) {
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)60000L, () -> master.getAssignmentManager().getRegionStates().getRegionsInTransitionCount() <= 0);
    }
}

