/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshot;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestMobExportSnapshot
extends TestExportSnapshot {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobExportSnapshot.class);

    public static void setUpBaseConf(Configuration conf) {
        TestExportSnapshot.setUpBaseConf(conf);
        conf.setInt("hbase.mob.file.cache.size", 0);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestMobExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @Override
    protected void createTable(TableName tableName) throws Exception {
        MobSnapshotTestingUtils.createPreSplitMobTable((HBaseTestingUtility)TEST_UTIL, (TableName)tableName, (int)2, (byte[][])new byte[][]{FAMILY});
    }

    @Override
    protected TestExportSnapshot.RegionPredicate getBypassRegionPredicate() {
        return new TestExportSnapshot.RegionPredicate(){

            @Override
            public boolean evaluate(RegionInfo regionInfo) {
                return MobUtils.isMobRegionInfo((RegionInfo)regionInfo);
            }
        };
    }
}

