/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.AbstractResultResponse;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.util.Strings;

public class BindResponseImpl
extends AbstractResultResponse
implements BindResponse {
    static final long serialVersionUID = -5146809476518669755L;
    private byte[] serverSaslCreds;

    public BindResponseImpl() {
        super(-1, TYPE);
    }

    public BindResponseImpl(int id) {
        super(id, TYPE);
    }

    @Override
    public byte[] getServerSaslCreds() {
        if (this.serverSaslCreds == null) {
            return null;
        }
        byte[] copy = new byte[this.serverSaslCreds.length];
        System.arraycopy(this.serverSaslCreds, 0, copy, 0, this.serverSaslCreds.length);
        return copy;
    }

    @Override
    public void setServerSaslCreds(byte[] serverSaslCreds) {
        if (serverSaslCreds != null) {
            this.serverSaslCreds = new byte[serverSaslCreds.length];
            System.arraycopy(serverSaslCreds, 0, this.serverSaslCreds, 0, serverSaslCreds.length);
        } else {
            this.serverSaslCreds = null;
        }
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + Arrays.hashCode(this.serverSaslCreds);
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BindResponse)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BindResponse response = (BindResponse)obj;
        byte[] creds = response.getServerSaslCreds();
        if (this.serverSaslCreds == null ? creds != null : creds == null) {
            return false;
        }
        return Arrays.equals(this.serverSaslCreds, creds);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    BindResponse\n");
        sb.append(super.toString());
        if (this.serverSaslCreds != null) {
            sb.append("        Server sasl credentials : '").append(Strings.dumpBytes((byte[])this.serverSaslCreds)).append("'\n");
        }
        return super.toString(sb.toString());
    }
}

