/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.hbck1;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.ReplicationStorageFactoryHelper;
import org.apache.hbase.hbck1.HBaseFsck;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationChecker.class);
    private final HBaseFsck.ErrorReporter errorReporter;
    private final UnDeletedQueueChecker unDeletedQueueChecker;
    private Set<String> undeletedHFileRefsPeerIds = Collections.emptySet();
    private final ReplicationPeerStorage peerStorage;
    private final ReplicationQueueStorage queueStorage;

    private UnDeletedQueueChecker initUnDeletedQueueChecker() {
        try {
            ReplicationQueueStorage.class.getMethod("listAllPeerIds", new Class[0]);
            return new UnDeletedQueueChecker3();
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No listAllPeerIds method, should be hbase 2", e);
            return new UnDeletedQueueChecker2();
        }
    }

    public ReplicationChecker(Configuration conf, ZKWatcher zkw, FileSystem fs, Connection conn, HBaseFsck.ErrorReporter errorReporter) {
        this.peerStorage = ReplicationStorageFactoryHelper.getReplicationPeerStorage(conf, zkw, fs);
        this.queueStorage = ReplicationStorageFactoryHelper.getReplicationQueueStorage(conf, zkw, conn);
        this.errorReporter = errorReporter;
        this.unDeletedQueueChecker = this.initUnDeletedQueueChecker();
    }

    public boolean hasUnDeletedQueues() {
        return this.errorReporter.getErrorList().contains((Object)HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE);
    }

    private Set<String> getUndeletedHFileRefsPeers() throws ReplicationException {
        HashSet<String> undeletedHFileRefsPeerIds = new HashSet<String>(this.queueStorage.getAllPeersFromHFileRefsQueue());
        HashSet peerIds = new HashSet(this.peerStorage.listPeerIds());
        undeletedHFileRefsPeerIds.removeAll(peerIds);
        if (LOG.isDebugEnabled()) {
            for (String peerId : undeletedHFileRefsPeerIds) {
                LOG.debug("Undeleted replication hfile-refs queue for removed peer {} found", (Object)peerId);
            }
        }
        return undeletedHFileRefsPeerIds;
    }

    private boolean hasData() throws ReplicationException {
        Method hasDataMethod;
        try {
            hasDataMethod = ReplicationQueueStorage.class.getMethod("hasData", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No hasData method, should be hbase 2", e);
            return true;
        }
        try {
            return (Boolean)hasDataMethod.invoke((Object)this.queueStorage, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), ReplicationException.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    public void checkUnDeletedQueues() throws ReplicationException {
        if (!this.hasData()) {
            return;
        }
        this.unDeletedQueueChecker.check();
        this.undeletedHFileRefsPeerIds = this.getUndeletedHFileRefsPeers();
        this.undeletedHFileRefsPeerIds.stream().map(peerId -> "Undeleted replication hfile-refs queue for removed peer " + peerId + " found").forEach(msg -> this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, (String)msg));
    }

    public void fixUnDeletedQueues() throws ReplicationException {
        this.unDeletedQueueChecker.fix();
        for (String peerId : this.undeletedHFileRefsPeerIds) {
            this.queueStorage.removePeerFromHFileRefs(peerId);
        }
    }

    private final class UnDeletedQueueChecker3
    implements UnDeletedQueueChecker {
        private final Method listAllPeerIds;
        private final Method removeAllQueues;
        private List<String> unDeletedPeerIds = Collections.emptyList();

        UnDeletedQueueChecker3() {
            try {
                this.listAllPeerIds = ReplicationQueueStorage.class.getMethod("listAllPeerIds", new Class[0]);
                this.removeAllQueues = ReplicationQueueStorage.class.getMethod("removeAllQueues", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("method unavailable", e);
            }
        }

        private List<String> getUnDeletedPeerIds() throws ReplicationException {
            ArrayList<String> unDeletedPeerIds = new ArrayList<String>();
            try {
                HashSet peerIds = new HashSet(ReplicationChecker.this.peerStorage.listPeerIds());
                for (String peerId : (List)this.listAllPeerIds.invoke((Object)ReplicationChecker.this.queueStorage, new Object[0])) {
                    if (peerIds.contains(peerId)) continue;
                    unDeletedPeerIds.add(peerId);
                }
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), ReplicationException.class);
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return unDeletedPeerIds;
        }

        @Override
        public void check() throws ReplicationException {
            this.unDeletedPeerIds = this.getUnDeletedPeerIds();
            this.unDeletedPeerIds.forEach(peerId -> {
                String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s]", peerId);
                ReplicationChecker.this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
            });
        }

        @Override
        public void fix() throws ReplicationException {
            try {
                for (String peerId : this.unDeletedPeerIds) {
                    this.removeAllQueues.invoke((Object)ReplicationChecker.this.queueStorage, peerId);
                }
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), ReplicationException.class);
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class UnDeletedQueueChecker2
    implements UnDeletedQueueChecker {
        private final Method getListOfReplicators;
        private final Method getAllQueues;
        private final Method removeQueue;
        private final Method removeReplicatorIfQueueIsEmpty;
        private Map<ServerName, List<String>> undeletedQueueIds = Collections.emptyMap();

        UnDeletedQueueChecker2() {
            try {
                this.getListOfReplicators = ReplicationQueueStorage.class.getMethod("getListOfReplicators", new Class[0]);
                this.getAllQueues = ReplicationQueueStorage.class.getMethod("getAllQueues", ServerName.class);
                this.removeQueue = ReplicationQueueStorage.class.getMethod("removeQueue", ServerName.class, String.class);
                this.removeReplicatorIfQueueIsEmpty = ReplicationQueueStorage.class.getMethod("removeReplicatorIfQueueIsEmpty", ServerName.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("method unavailable", e);
            }
        }

        private Map<ServerName, List<String>> getUnDeletedQueues() throws ReplicationException {
            HashMap<ServerName, List<String>> undeletedQueues = new HashMap<ServerName, List<String>>();
            HashSet peerIds = new HashSet(ReplicationChecker.this.peerStorage.listPeerIds());
            try {
                for (ServerName replicator : (List)this.getListOfReplicators.invoke((Object)ReplicationChecker.this.queueStorage, new Object[0])) {
                    for (String queueId : (List)this.getAllQueues.invoke((Object)ReplicationChecker.this.queueStorage, replicator)) {
                        ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                        if (peerIds.contains(queueInfo.getPeerId())) continue;
                        undeletedQueues.computeIfAbsent(replicator, key -> new ArrayList()).add(queueId);
                        LOG.debug("Undeleted replication queue for removed peer found: [removedPeerId={}, replicator={}, queueId={}]", queueInfo.getPeerId(), replicator, queueId);
                    }
                }
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), ReplicationException.class);
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return undeletedQueues;
        }

        @Override
        public void check() throws ReplicationException {
            this.undeletedQueueIds = this.getUnDeletedQueues();
            this.undeletedQueueIds.forEach((replicator, queueIds) -> queueIds.forEach(queueId -> {
                ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueInfo.getPeerId(), replicator, queueId);
                ReplicationChecker.this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
            }));
        }

        @Override
        public void fix() throws ReplicationException {
            try {
                for (Map.Entry<ServerName, List<String>> replicatorAndQueueIds : this.undeletedQueueIds.entrySet()) {
                    ServerName replicator = replicatorAndQueueIds.getKey();
                    for (String queueId : replicatorAndQueueIds.getValue()) {
                        this.removeQueue.invoke((Object)ReplicationChecker.this.queueStorage, replicator, queueId);
                    }
                    this.removeReplicatorIfQueueIsEmpty.invoke((Object)ReplicationChecker.this.queueStorage, replicator);
                }
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), ReplicationException.class);
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface UnDeletedQueueChecker {
        public void check() throws ReplicationException;

        public void fix() throws ReplicationException;
    }
}

