/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DnSerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient SchemaManager schemaManager;

    public DnSerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public byte[] serialize(Object object) throws IOException {
        Dn dn = (Dn)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        dn.writeExternal((ObjectOutput)out);
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialized " + dn);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            Dn dn = new Dn();
            dn.readExternal((ObjectInput)in);
            return dn;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }
}

