/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface RSGroupInfoManager {
    public static final String REASSIGN_WAIT_INTERVAL_KEY = "hbase.rsgroup.reassign.wait";
    public static final long DEFAULT_REASSIGN_WAIT_INTERVAL = 30000L;
    public static final TableName RSGROUP_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"rsgroup");
    public static final String rsGroupZNode = "rsgroup";
    public static final byte[] META_FAMILY_BYTES = Bytes.toBytes((String)"m");
    public static final byte[] META_QUALIFIER_BYTES = Bytes.toBytes((String)"i");
    public static final byte[] ROW_KEY = new byte[]{0};

    public void start();

    public void addRSGroup(RSGroupInfo var1) throws IOException;

    public void removeRSGroup(String var1) throws IOException;

    public Set<Address> moveServers(Set<Address> var1, String var2, String var3) throws IOException;

    public RSGroupInfo getRSGroupOfServer(Address var1) throws IOException;

    public RSGroupInfo getRSGroup(String var1) throws IOException;

    public String getRSGroupOfTable(TableName var1) throws IOException;

    public void moveTables(Set<TableName> var1, String var2) throws IOException;

    public List<RSGroupInfo> listRSGroups() throws IOException;

    public void refresh() throws IOException;

    public boolean isOnline();

    public void moveServersAndTables(Set<Address> var1, Set<TableName> var2, String var3, String var4) throws IOException;

    public void removeServers(Set<Address> var1) throws IOException;

    public void renameRSGroup(String var1, String var2) throws IOException;

    public RSGroupInfo determineRSGroupInfoForTable(TableName var1) throws IOException;

    public void updateRSGroupConfig(String var1, Map<String, String> var2) throws IOException;
}

