/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAssignRegionToUninitializedRegionServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignRegionToUninitializedRegionServer.class);
    private static CountDownLatch ARRIVE;
    private static CountDownLatch RESUME;
    private static AtomicBoolean ASSIGN_CALLED;
    private static final HBaseTestingUtility UTIL;
    private static TableName NAME;
    private static byte[] FAMILY;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.createTable(NAME, FAMILY);
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMove() throws Exception {
        CountDownLatch arrive;
        UTIL.getMiniHBaseCluster().getConfiguration().setClass("hbase.regionserver.impl", RegionServerForTest.class, HRegionServer.class);
        ARRIVE = arrive = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        Future regionServerFuture = ForkJoinPool.commonPool().submit(() -> UTIL.getMiniHBaseCluster().startRegionServer().getRegionServer());
        ARRIVE.await();
        HRegionServer src = UTIL.getRSForFirstRegionInTable(NAME);
        HRegionServer dst = UTIL.getOtherRegionServer(src);
        try {
            UTIL.getAdmin().move(((RegionInfo)UTIL.getAdmin().getRegions(NAME).get(0)).getEncodedNameAsBytes(), dst.getServerName());
            Assert.assertSame((Object)src, (Object)UTIL.getRSForFirstRegionInTable(NAME));
            Assert.assertFalse((boolean)ASSIGN_CALLED.get());
        }
        finally {
            RESUME.countDown();
        }
        Assert.assertSame((Object)dst, regionServerFuture.get());
        UTIL.getAdmin().move(((RegionInfo)UTIL.getAdmin().getRegions(NAME).get(0)).getEncodedNameAsBytes(), dst.getServerName());
        Assert.assertSame((Object)dst, (Object)UTIL.getRSForFirstRegionInTable(NAME));
        Assert.assertTrue((boolean)ASSIGN_CALLED.get());
    }

    static {
        ASSIGN_CALLED = new AtomicBoolean(false);
        UTIL = new HBaseTestingUtility();
        NAME = TableName.valueOf((String)"test");
        FAMILY = Bytes.toBytes((String)"family");
    }

    public static final class RegionServerForTest
    extends HRegionServer {
        public RegionServerForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
            if (ARRIVE != null) {
                ARRIVE.countDown();
                ARRIVE = null;
                try {
                    RESUME.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.tryRegionServerReport(reportStartTime, reportEndTime);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new RSRpcServicesForTest(this);
        }
    }

    public static final class RSRpcServicesForTest
    extends RSRpcServices {
        public RSRpcServicesForTest(HRegionServer rs) throws IOException {
            super(rs);
        }

        public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
            if (request.getOpenRegionCount() > 0) {
                ASSIGN_CALLED.set(true);
            }
            return super.executeProcedures(controller, request);
        }
    }
}

