/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMetaRegionReplicaReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaRegionReplicaReplicationEndpoint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaRegionReplicaReplicationEndpoint.class);
    private static final int NB_SERVERS = 4;
    private final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private int numOfMetaReplica = 3;
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws Exception {
        Configuration conf = this.HTU.getConfiguration();
        conf.setFloat("hbase.regionserver.logroll.multiplier", 3.0E-4f);
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        conf.setBoolean("hbase.region.replica.replication.catalog.enabled", true);
        this.HTU.startMiniCluster(4);
        HBaseTestingUtility.setReplicas(this.HTU.getAdmin(), TableName.META_TABLE_NAME, this.numOfMetaReplica);
        this.HTU.waitFor(30000L, () -> this.HTU.getMiniHBaseCluster().getRegions(TableName.META_TABLE_NAME).size() >= this.numOfMetaReplica);
    }

    @After
    public void after() throws Exception {
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void testHBaseMetaReplicationSourceCreatedOnOpen() throws Exception {
        MiniHBaseCluster cluster = this.HTU.getMiniHBaseCluster();
        HRegionServer hrs = cluster.getRegionServer(cluster.getServerHoldingMeta());
        this.testHBaseMetaReplicatesOneRow(0);
        Assert.assertTrue((boolean)this.isMetaRegionReplicaReplicationSource(hrs));
        HRegionServer hrsOther = null;
        for (int i = 0; i < cluster.getNumLiveRegionServers() && (hrsOther = cluster.getRegionServer(i)).getServerName().equals((Object)hrs.getServerName()); ++i) {
            hrsOther = null;
        }
        Assert.assertNotNull(hrsOther);
        Assert.assertFalse((boolean)this.isMetaRegionReplicaReplicationSource(hrsOther));
        Region meta = null;
        for (Region region : hrs.getOnlineRegionsLocalContext()) {
            if (!region.getRegionInfo().isMetaRegion()) continue;
            meta = region;
            break;
        }
        Assert.assertNotNull(meta);
        this.HTU.moveRegionAndWait(meta.getRegionInfo(), hrsOther.getServerName());
        Assert.assertTrue((boolean)this.isMetaRegionReplicaReplicationSource(hrs));
        Assert.assertTrue((boolean)this.isMetaRegionReplicaReplicationSource(hrsOther));
        this.testHBaseMetaReplicatesOneRow(1);
        hrs.getWAL(meta.getRegionInfo()).rollWriter(true);
        this.testHBaseMetaReplicatesOneRow(2);
        hrs.getWAL(meta.getRegionInfo()).rollWriter(true);
        this.testHBaseMetaReplicatesOneRow(3);
    }

    private void testHBaseMetaReplicatesOneRow(int i) throws Exception {
        this.waitForMetaReplicasToOnline();
        try (Table table = this.HTU.createTable(TableName.valueOf((String)(this.name.getMethodName() + "_" + i)), HConstants.CATALOG_FAMILY);){
            this.verifyReplication(TableName.META_TABLE_NAME, this.numOfMetaReplica, this.getMetaCells(table.getName()));
        }
    }

    private boolean isMetaRegionReplicaReplicationSource(HRegionServer hrs) {
        return hrs.getReplicationSourceService().getReplicationManager().catalogReplicationSource.get() != null;
    }

    @Test
    public void testHBaseMetaReplicates() throws Exception {
        try (Table table = this.HTU.createTable(TableName.valueOf((String)(this.name.getMethodName() + "_0")), HConstants.CATALOG_FAMILY, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));){
            this.verifyReplication(TableName.META_TABLE_NAME, this.numOfMetaReplica, this.getMetaCells(table.getName()));
        }
        table = this.HTU.createTable(TableName.valueOf((String)(this.name.getMethodName() + "_1")), HConstants.CATALOG_FAMILY, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));
        var2_2 = null;
        try {
            this.verifyReplication(TableName.META_TABLE_NAME, this.numOfMetaReplica, this.getMetaCells(table.getName()));
            this.HTU.deleteTableIfAny(table.getName());
            this.verifyDeletedReplication(TableName.META_TABLE_NAME, this.numOfMetaReplica, table.getName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var2_2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatalogReplicaReplicationWithFlushAndCompaction() throws Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)this.HTU.getConfiguration());
        TableName tableName = TableName.valueOf((String)"hbase:meta");
        Table table = connection.getTable(tableName);
        try {
            for (int i = 0; i < 5; ++i) {
                LOG.info("Writing data from " + i * 1000 + " to " + (i * 1000 + 1000));
                this.HTU.loadNumericRows(table, HConstants.CATALOG_FAMILY, i * 1000, i * 1000 + 1000);
                LOG.info("flushing table");
                this.HTU.flush(tableName);
                LOG.info("compacting table");
                if (i >= 4) continue;
                this.HTU.compact(tableName, false);
            }
            this.verifyReplication(tableName, this.numOfMetaReplica, 0, 5000, HConstants.CATALOG_FAMILY);
        }
        finally {
            table.close();
            connection.close();
        }
    }

    @Test
    public void testCatalogReplicaReplicationWALRolledAndDeleted() throws Exception {
        TableName tableName = TableName.valueOf((String)"hbase:meta");
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.HTU.getConfiguration());
             Table table = connection.getTable(tableName);){
            int i;
            MiniHBaseCluster cluster = this.HTU.getHBaseCluster();
            cluster.getMaster().balanceSwitch(false);
            HRegionServer hrs = cluster.getRegionServer(cluster.getServerHoldingMeta());
            ReplicationSource source = (ReplicationSource)hrs.getReplicationSourceService().getReplicationManager().catalogReplicationSource.get();
            ((ReplicationPeerImpl)source.replicationPeer).setPeerState(false);
            this.HTU.waitFor(2000L, 100L, true, () -> {
                MutableObject readerWaiting = new MutableObject((Object)true);
                source.logQueue.getQueues().keySet().forEach(w -> readerWaiting.setValue((Object)((Boolean)readerWaiting.getValue() != false && ((ReplicationSourceShipper)source.workerThreads.get((Object)w)).entryReader.waitingPeerEnabled.get() ? 1 : 0)));
                return (Boolean)readerWaiting.getValue();
            });
            for (i = 0; i < 5; ++i) {
                LOG.info("Writing data from " + i * 1000 + " to " + (i * 1000 + 1000));
                this.HTU.loadNumericRows(table, HConstants.CATALOG_FAMILY, i * 1000, i * 1000 + 1000);
                LOG.info("flushing table");
                this.HTU.flush(tableName);
                LOG.info("compacting table");
                if (i >= 4) continue;
                this.HTU.compact(tableName, false);
            }
            this.HTU.getHBaseCluster().getMaster().getLogCleaner().runCleaner();
            ((ReplicationPeerImpl)source.replicationPeer).setPeerState(true);
            for (i = 5; i < 10; ++i) {
                LOG.info("Writing data from " + i * 1000 + " to " + (i * 1000 + 1000));
                this.HTU.loadNumericRows(table, HConstants.CATALOG_FAMILY, i * 1000, i * 1000 + 1000);
            }
            this.verifyReplication(tableName, this.numOfMetaReplica, 0, 10000, HConstants.CATALOG_FAMILY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatalogReplicaReplicationWithReplicaMoved() throws Exception {
        MiniHBaseCluster cluster = this.HTU.getMiniHBaseCluster();
        HRegionServer hrs = cluster.getRegionServer(cluster.getServerHoldingMeta());
        Object hrsMetaReplica = null;
        HRegionServer hrsNoMetaReplica = null;
        HRegionServer server = null;
        Region metaReplica = null;
        for (int i = 0; i < cluster.getNumLiveRegionServers(); ++i) {
            server = cluster.getRegionServer(i);
            boolean hostingMeta = false;
            if (server == hrs) continue;
            for (Region region : server.getOnlineRegionsLocalContext()) {
                if (!region.getRegionInfo().isMetaRegion()) continue;
                if (metaReplica == null) {
                    metaReplica = region;
                }
                hostingMeta = true;
                break;
            }
            if (hostingMeta) continue;
            hrsNoMetaReplica = server;
        }
        Connection connection = ConnectionFactory.createConnection((Configuration)this.HTU.getConfiguration());
        TableName tableName = TableName.valueOf((String)"hbase:meta");
        Table table = connection.getTable(tableName);
        try {
            for (int i = 0; i < 5; ++i) {
                LOG.info("Writing data from " + i * 1000 + " to " + (i * 1000 + 1000));
                this.HTU.loadNumericRows(table, HConstants.CATALOG_FAMILY, i * 1000, i * 1000 + 1000);
                if (i != 0) continue;
                this.HTU.moveRegionAndWait(metaReplica.getRegionInfo(), hrsNoMetaReplica.getServerName());
            }
            this.verifyReplication(tableName, this.numOfMetaReplica, 0, 5000, HConstants.CATALOG_FAMILY);
        }
        finally {
            table.close();
            connection.close();
        }
    }

    protected void verifyReplication(TableName tableName, int regionReplication, int startRow, int endRow, byte[] family) throws Exception {
        this.verifyReplication(tableName, regionReplication, startRow, endRow, family, true);
    }

    private void verifyReplication(TableName tableName, int regionReplication, final int startRow, final int endRow, final byte[] family, final boolean present) throws Exception {
        Region[] regions = new Region[regionReplication];
        for (int i = 0; i < 4; ++i) {
            HRegionServer rs = this.HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                regions[region.getRegionInfo().getReplicaId()] = region;
            }
        }
        for (Region region : regions) {
            Assert.assertNotNull((Object)region);
        }
        for (int i = 1; i < regionReplication; ++i) {
            final Region region = regions[i];
            Waiter.waitFor((Configuration)this.HTU.getConfiguration(), (long)90000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    LOG.info("verifying replication for region replica:" + region.getRegionInfo());
                    try {
                        TestMetaRegionReplicaReplicationEndpoint.this.HTU.verifyNumericRows(region, family, startRow, endRow, present);
                    }
                    catch (Throwable ex) {
                        LOG.warn("Verification from secondary region is not complete yet", ex);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    private void waitForMetaReplicasToOnline() throws IOException {
        RegionLocator regionLocator = this.HTU.getConnection().getRegionLocator(TableName.META_TABLE_NAME);
        this.HTU.waitFor(10000L, () -> regionLocator.getRegionLocations(HConstants.EMPTY_START_ROW, true).stream().filter(Objects::nonNull).count() >= (long)this.numOfMetaReplica);
        List locations = regionLocator.getRegionLocations(HConstants.EMPTY_START_ROW);
        LOG.info("Found locations {}", (Object)locations);
        Assert.assertEquals((long)this.numOfMetaReplica, (long)locations.size());
    }

    private List<Result> getMetaCells(TableName tableName) throws IOException {
        final ArrayList<Result> results = new ArrayList<Result>();
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                results.add(r);
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions((Connection)this.HTU.getConnection(), (MetaTableAccessor.Visitor)visitor, (TableName)tableName);
        return results;
    }

    private Region[] getAllRegions(TableName tableName, int replication) {
        Region[] regions = new Region[replication];
        for (int i = 0; i < 4; ++i) {
            HRegionServer rs = this.HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                regions[region.getRegionInfo().getReplicaId()] = region;
            }
        }
        for (Region region : regions) {
            Assert.assertNotNull((Object)region);
        }
        return regions;
    }

    private Region getOneRegion(TableName tableName) {
        for (int i = 0; i < 4; ++i) {
            HRegionServer rs = this.HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            if (onlineRegions.size() <= 1) continue;
            return (Region)onlineRegions.get(0);
        }
        return null;
    }

    private void verifyDeletedReplication(TableName tableName, int regionReplication, final TableName deletedTableName) {
        Region[] regions = this.getAllRegions(tableName, regionReplication);
        for (int i = 1; i < regionReplication; ++i) {
            final Region region = regions[i];
            Waiter.waitFor((Configuration)this.HTU.getConfiguration(), (long)30000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean evaluate() throws Exception {
                    LOG.info("Verifying replication for region replica {}", (Object)region.getRegionInfo());
                    try (RegionScanner rs = region.getScanner(new Scan());){
                        ArrayList cells = new ArrayList();
                        while (rs.next(cells)) {
                        }
                        boolean bl = TestMetaRegionReplicaReplicationEndpoint.this.doesNotContain(cells, deletedTableName);
                        return bl;
                    }
                    catch (Throwable ex) {
                        LOG.warn("Verification from secondary region is not complete yet", ex);
                        return false;
                    }
                }
            });
        }
    }

    private boolean doesNotContain(List<Cell> cells, TableName tableName) {
        for (Cell cell : cells) {
            String row = Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
            if (!row.startsWith(tableName.toString() + 44)) continue;
            return false;
        }
        return true;
    }

    private void verifyReplication(TableName tableName, int regionReplication, final List<Result> contains) {
        Region[] regions = this.getAllRegions(tableName, regionReplication);
        for (int i = 1; i < regionReplication; ++i) {
            final Region region = regions[i];
            Waiter.waitFor((Configuration)this.HTU.getConfiguration(), (long)30000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean evaluate() throws Exception {
                    LOG.info("Verifying replication for region replica {}", (Object)region.getRegionInfo());
                    try (RegionScanner rs = region.getScanner(new Scan());){
                        ArrayList<Cell> cells = new ArrayList<Cell>();
                        while (rs.next(cells)) {
                        }
                        boolean bl = TestMetaRegionReplicaReplicationEndpoint.contains(contains, cells);
                        return bl;
                    }
                    catch (Throwable ex) {
                        LOG.warn("Verification from secondary region is not complete yet", ex);
                        return false;
                    }
                }
            });
        }
    }

    static boolean contains(List<Result> contains, List<Cell> cells) throws IOException {
        CellScanner containsScanner = CellUtil.createCellScanner(contains);
        CellScanner cellsScanner = CellUtil.createCellScanner(cells);
        int matches = 0;
        int count = 0;
        block0: while (containsScanner.advance()) {
            while (cellsScanner.advance()) {
                ++count;
                LOG.info("{} {}", (Object)containsScanner.current(), (Object)cellsScanner.current());
                if (!containsScanner.current().equals(cellsScanner.current())) continue;
                ++matches;
                continue block0;
            }
        }
        return !containsScanner.advance() && matches >= 1 && count >= matches && count == cells.size();
    }

    private void doNGets(Table table, byte[][] keys) throws Exception {
        for (byte[] key : keys) {
            Result r = table.get(new Get(key));
            Assert.assertArrayEquals((byte[])VALUE, (byte[])r.getValue(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY));
        }
    }

    private void primaryNoChangeReplicaIncrease(long[] before, long[] after) {
        Assert.assertEquals((long)before[0], (long)after[0]);
        for (int i = 1; i < after.length; ++i) {
            Assert.assertTrue((after[i] > before[i] ? 1 : 0) != 0);
        }
    }

    private void primaryIncreaseReplicaNoChange(long[] before, long[] after) {
        Assert.assertTrue((after[0] > before[0] ? 1 : 0) != 0);
        for (int i = 1; i < after.length; ++i) {
            Assert.assertEquals((long)before[i], (long)after[i]);
        }
    }

    private void primaryMayIncreaseReplicaNoChange(long[] before, long[] after) {
        Assert.assertTrue((after[0] >= before[0] ? 1 : 0) != 0);
        for (int i = 1; i < after.length; ++i) {
            Assert.assertEquals((long)before[i], (long)after[i]);
        }
    }

    private void primaryIncreaseReplicaIncrease(long[] before, long[] after) {
        for (int i = 0; i < after.length; ++i) {
            Assert.assertTrue((after[i] > before[i] ? 1 : 0) != 0);
        }
    }

    private void getMetaReplicaReadRequests(Region[] metaRegions, long[] counters) {
        int i = 0;
        for (Region r : metaRegions) {
            LOG.info("read request for region {} is {}", (Object)r, (Object)r.getReadRequestsCount());
            counters[i] = r.getReadRequestsCount();
            ++i;
        }
    }

    @Test
    public void testHBaseMetaReplicaGets() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Region[] metaRegions = this.getAllRegions(TableName.META_TABLE_NAME, this.numOfMetaReplica);
        long[] readReqsForMetaReplicas = new long[this.numOfMetaReplica];
        long[] readReqsForMetaReplicasAfterGet = new long[this.numOfMetaReplica];
        long[] readReqsForMetaReplicasAfterGetAllLocations = new long[this.numOfMetaReplica];
        long[] readReqsForMetaReplicasAfterMove = new long[this.numOfMetaReplica];
        long[] readReqsForMetaReplicasAfterSecondMove = new long[this.numOfMetaReplica];
        long[] readReqsForMetaReplicasAfterThirdGet = new long[this.numOfMetaReplica];
        Region userRegion = null;
        HRegionServer srcRs = null;
        HRegionServer destRs = null;
        try (Table table = this.HTU.createTable(tn, HConstants.CATALOG_FAMILY, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));){
            this.verifyReplication(TableName.META_TABLE_NAME, this.numOfMetaReplica, this.getMetaCells(table.getName()));
            this.HTU.loadTable(table, new byte[][]{HConstants.CATALOG_FAMILY}, VALUE);
            for (int i = 0; i < 4; ++i) {
                HRegionServer rs = this.HTU.getMiniHBaseCluster().getRegionServer(i);
                List onlineRegions = rs.getRegions(tn);
                if (onlineRegions.size() <= 0) continue;
                userRegion = (Region)onlineRegions.get(0);
                srcRs = rs;
                destRs = i > 0 ? this.HTU.getMiniHBaseCluster().getRegionServer(0) : this.HTU.getMiniHBaseCluster().getRegionServer(1);
            }
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicas);
            Configuration c = new Configuration(this.HTU.getConfiguration());
            c.set("hbase.locator.meta.replicas.mode", "LoadBalance");
            Connection connection = ConnectionFactory.createConnection((Configuration)c);
            Table tableForGet = connection.getTable(tn);
            byte[][] getRows = new byte[HBaseTestingUtility.KEYS.length][];
            int i = 0;
            for (byte[] key : HBaseTestingUtility.KEYS) {
                getRows[i] = key;
                ++i;
            }
            getRows[0] = Bytes.toBytes((String)"aaa");
            this.doNGets(tableForGet, getRows);
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicasAfterGet);
            this.primaryIncreaseReplicaIncrease(readReqsForMetaReplicas, readReqsForMetaReplicasAfterGet);
            RegionLocator locator = tableForGet.getRegionLocator();
            for (int j = 0; j < this.numOfMetaReplica * 3; ++j) {
                locator.getAllRegionLocations();
            }
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicasAfterGetAllLocations);
            this.primaryIncreaseReplicaIncrease(readReqsForMetaReplicasAfterGet, readReqsForMetaReplicasAfterGetAllLocations);
            this.HTU.moveRegionAndWait(userRegion.getRegionInfo(), destRs.getServerName());
            this.doNGets(tableForGet, getRows);
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicasAfterMove);
            this.primaryIncreaseReplicaNoChange(readReqsForMetaReplicasAfterGetAllLocations, readReqsForMetaReplicasAfterMove);
            this.HTU.moveRegionAndWait(userRegion.getRegionInfo(), srcRs.getServerName());
            while (destRs.getMovedRegion(userRegion.getRegionInfo().getEncodedName()) != null) {
                Thread.sleep(1000L);
            }
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicasAfterSecondMove);
            this.primaryMayIncreaseReplicaNoChange(readReqsForMetaReplicasAfterMove, readReqsForMetaReplicasAfterSecondMove);
            this.doNGets(tableForGet, getRows);
            this.getMetaReplicaReadRequests(metaRegions, readReqsForMetaReplicasAfterThirdGet);
            this.primaryIncreaseReplicaNoChange(readReqsForMetaReplicasAfterSecondMove, readReqsForMetaReplicasAfterThirdGet);
        }
    }
}

