/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExpAsStringVisibilityLabelServiceImpl
implements VisibilityLabelService {
    private static final Logger LOG = LoggerFactory.getLogger(ExpAsStringVisibilityLabelServiceImpl.class);
    private static final byte[] DUMMY_VALUE = new byte[0];
    private static final byte STRING_SERIALIZATION_FORMAT = 2;
    private static final Tag STRING_SERIALIZATION_FORMAT_TAG = new ArrayBackedTag(4, new byte[]{2});
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final ExpressionExpander expressionExpander = new ExpressionExpander();
    private Configuration conf;
    private Region labelsRegion;
    private List<ScanLabelGenerator> scanLabelGenerators;

    public OperationStatus[] addLabels(List<byte[]> labels) throws IOException {
        OperationStatus[] status = new OperationStatus[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            status[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return status;
    }

    public OperationStatus[] setAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        Put p = new Put(user);
        CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        for (byte[] auth : authLabels) {
            p.add(builder.clear().setRow(p.getRow()).setFamily(VisibilityConstants.LABELS_TABLE_FAMILY).setQualifier(auth).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(DUMMY_VALUE).build());
        }
        this.labelsRegion.put(p);
        for (int i = 0; i < authLabels.size(); ++i) {
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    public OperationStatus[] clearAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        List<String> currentAuths;
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        if (AuthUtil.isGroupPrincipal((String)Bytes.toString((byte[])user))) {
            String group = AuthUtil.getGroupName((String)Bytes.toString((byte[])user));
            currentAuths = this.getGroupAuths(new String[]{group}, true);
        } else {
            currentAuths = this.getUserAuths(user, true);
        }
        Delete d = new Delete(user);
        int i = 0;
        for (byte[] authLabel : authLabels) {
            String authLabelStr = Bytes.toString((byte[])authLabel);
            if (currentAuths.contains(authLabelStr)) {
                d.addColumns(VisibilityConstants.LABELS_TABLE_FAMILY, authLabel);
            } else {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, (Exception)new InvalidLabelException("Label '" + authLabelStr + "' is not set for the user " + Bytes.toString((byte[])user)));
            }
            ++i;
        }
        this.labelsRegion.delete(d);
        for (i = 0; i < authLabels.size(); ++i) {
            if (finalOpStatus[i] != null) continue;
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    public List<String> getUserAuths(byte[] user, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        ArrayList<String> auths = new ArrayList<String>();
        Get get = new Get(user);
        this.getAuths(get, auths);
        return auths;
    }

    public List<String> getGroupAuths(String[] groups, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        ArrayList<String> auths = new ArrayList<String>();
        if (groups != null && groups.length > 0) {
            for (String group : groups) {
                Get get = new Get(Bytes.toBytes((String)AuthUtil.toGroupEntry((String)group)));
                this.getAuths(get, auths);
            }
        }
        return auths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAuths(Get get, List<String> auths) throws IOException {
        List cells = new ArrayList();
        try (RegionScanner scanner = null;){
            if (this.labelsRegion == null) {
                Table table = null;
                Connection connection = null;
                try {
                    connection = ConnectionFactory.createConnection((Configuration)this.conf);
                    table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);
                    Result result = table.get(get);
                    cells = result.listCells();
                }
                finally {
                    if (table != null) {
                        table.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            } else {
                scanner = this.labelsRegion.getScanner(new Scan(get));
                scanner.next(cells);
            }
            for (Cell cell : cells) {
                String auth = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                auths.add(auth);
            }
        }
    }

    public List<String> listLabels(String regex) throws IOException {
        return new ArrayList<String>();
    }

    public List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths) throws IOException {
        ExpressionNode node = null;
        try {
            node = this.expressionParser.parse(visExpression);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        node = this.expressionExpander.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (withSerializationFormat) {
            tags.add(STRING_SERIALIZATION_FORMAT_TAG);
        }
        if (node instanceof NonLeafExpressionNode && ((NonLeafExpressionNode)node).getOperator() == Operator.OR) {
            for (ExpressionNode child : ((NonLeafExpressionNode)node).getChildExps()) {
                tags.add(this.createTag(child));
            }
        } else {
            tags.add(this.createTag(node));
        }
        return tags;
    }

    public VisibilityExpEvaluator getVisibilityExpEvaluator(Authorizations authorizations) throws IOException {
        if (this.isReadFromSystemAuthUser()) {
            return new VisibilityExpEvaluator(){

                public boolean evaluate(Cell cell) throws IOException {
                    return true;
                }
            };
        }
        List authLabels = null;
        for (ScanLabelGenerator scanLabelGenerator : this.scanLabelGenerators) {
            try {
                authLabels = scanLabelGenerator.getLabels(VisibilityUtils.getActiveUser(), authorizations);
                authLabels = authLabels == null ? new ArrayList() : authLabels;
                authorizations = new Authorizations(authLabels);
            }
            catch (Throwable t) {
                LOG.error(t.toString(), t);
                throw new IOException(t);
            }
        }
        final List authLabelsFinal = authLabels;
        return new VisibilityExpEvaluator(){

            public boolean evaluate(Cell cell) throws IOException {
                boolean visibilityTagPresent = false;
                if (cell.getTagsLength() > 0) {
                    Iterator tagsItr = PrivateCellUtil.tagsIterator((Cell)cell);
                    while (tagsItr.hasNext()) {
                        short len;
                        int offset;
                        boolean includeKV = true;
                        Tag tag = (Tag)tagsItr.next();
                        if (tag.getType() != 2) continue;
                        visibilityTagPresent = true;
                        int endOffset = offset + tag.getValueLength();
                        for (offset = tag.getValueOffset(); offset < endOffset; offset += len) {
                            String label;
                            len = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsShort(tag, offset);
                            offset += 2;
                            if (len < 0) {
                                label = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsString(tag, offset, len = (short)(-1 * len));
                                if (!authLabelsFinal.contains(label)) continue;
                                includeKV = false;
                                break;
                            }
                            label = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsString(tag, offset, len);
                            if (authLabelsFinal.contains(label)) continue;
                            includeKV = false;
                            break;
                        }
                        if (!includeKV) continue;
                        return true;
                    }
                }
                return !visibilityTagPresent;
            }
        };
    }

    protected boolean isReadFromSystemAuthUser() throws IOException {
        User user = VisibilityUtils.getActiveUser();
        return this.havingSystemAuth(user);
    }

    private Tag createTag(ExpressionNode node) throws IOException {
        byte[] bLabel;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> notLabels = new ArrayList<String>();
        this.extractLabels(node, labels, notLabels);
        Collections.sort(labels);
        Collections.sort(notLabels);
        for (String label : notLabels) {
            bLabel = Bytes.toBytes((String)label);
            short length = (short)bLabel.length;
            length = (short)(-1 * length);
            dos.writeShort(length);
            dos.write(bLabel);
        }
        for (String label : labels) {
            bLabel = Bytes.toBytes((String)label);
            dos.writeShort(bLabel.length);
            dos.write(bLabel);
        }
        return new ArrayBackedTag(2, baos.toByteArray());
    }

    private void extractLabels(ExpressionNode node, List<String> labels, List<String> notLabels) {
        if (node.isSingleNode()) {
            if (node instanceof NonLeafExpressionNode) {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                notLabels.add(lNode.getIdentifier());
            } else {
                labels.add(((LeafExpressionNode)node).getIdentifier());
            }
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            assert (nlNode.getOperator() == Operator.AND);
            List childExps = nlNode.getChildExps();
            for (ExpressionNode child : childExps) {
                this.extractLabels(child, labels, notLabels);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void init(RegionCoprocessorEnvironment e) throws IOException {
        this.scanLabelGenerators = VisibilityUtils.getScanLabelGenerators((Configuration)this.conf);
        if (e.getRegion().getRegionInfo().getTable().equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = e.getRegion();
        }
    }

    public boolean havingSystemAuth(User user) throws IOException {
        if (Superusers.isSuperUser((User)user)) {
            return true;
        }
        HashSet<String> auths = new HashSet<String>();
        auths.addAll(this.getUserAuths(Bytes.toBytes((String)user.getShortName()), true));
        auths.addAll(this.getGroupAuths(user.getGroupNames(), true));
        return auths.contains("system");
    }

    public boolean matchVisibility(List<Tag> putTags, Byte putTagsFormat, List<Tag> deleteTags, Byte deleteTagsFormat) throws IOException {
        assert (putTagsFormat == 2);
        assert (deleteTagsFormat == 2);
        return ExpAsStringVisibilityLabelServiceImpl.checkForMatchingVisibilityTagsWithSortedOrder(putTags, deleteTags);
    }

    private static boolean checkForMatchingVisibilityTagsWithSortedOrder(List<Tag> putVisTags, List<Tag> deleteVisTags) {
        if (putVisTags.isEmpty() && deleteVisTags.isEmpty()) {
            return true;
        }
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (Tag tag : deleteVisTags) {
                matchFound = false;
                for (Tag givenTag : putVisTags) {
                    if (!Tag.matchingValue((Tag)tag, (Tag)givenTag)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    public byte[] encodeVisibilityForReplication(List<Tag> tags, Byte serializationFormat) throws IOException {
        if (tags.size() > 0 && (serializationFormat == null || serializationFormat == 2)) {
            return this.createModifiedVisExpression(tags);
        }
        return null;
    }

    private byte[] createModifiedVisExpression(List<Tag> tags) throws IOException {
        StringBuilder visibilityString = new StringBuilder();
        for (Tag tag : tags) {
            short len;
            int offset;
            if (tag.getType() != 2) continue;
            if (visibilityString.length() != 0) {
                visibilityString.append(")|");
            }
            int endOffset = offset + tag.getValueLength();
            boolean expressionStart = true;
            for (offset = tag.getValueOffset(); offset < endOffset; offset += len) {
                String label;
                len = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsShort(tag, offset);
                offset += 2;
                if (len < 0) {
                    len = (short)(-1 * len);
                    label = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsString(tag, offset, len);
                    if (expressionStart) {
                        visibilityString.append("(!" + CellVisibility.quote((String)label));
                    } else {
                        visibilityString.append("&!" + CellVisibility.quote((String)label));
                    }
                } else {
                    label = ExpAsStringVisibilityLabelServiceImpl.getTagValuePartAsString(tag, offset, len);
                    if (expressionStart) {
                        visibilityString.append("(" + CellVisibility.quote((String)label));
                    } else {
                        visibilityString.append("&" + CellVisibility.quote((String)label));
                    }
                }
                expressionStart = false;
            }
        }
        if (visibilityString.length() != 0) {
            visibilityString.append(")");
            return Bytes.toBytes((String)visibilityString.toString());
        }
        return null;
    }

    private static short getTagValuePartAsShort(Tag t, int offset) {
        if (t.hasArray()) {
            return Bytes.toShort((byte[])t.getValueArray(), (int)offset);
        }
        return ByteBufferUtils.toShort((ByteBuffer)t.getValueByteBuffer(), (int)offset);
    }

    private static String getTagValuePartAsString(Tag t, int offset, int length) {
        if (t.hasArray()) {
            return Bytes.toString((byte[])t.getValueArray(), (int)offset, (int)length);
        }
        byte[] b = new byte[length];
        ByteBufferUtils.copyFromBufferToArray((byte[])b, (ByteBuffer)t.getValueByteBuffer(), (int)offset, (int)0, (int)length);
        return Bytes.toString((byte[])b);
    }
}

