/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChaosZKClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)ChaosZKClient.class.getName());
    private static final String CHAOS_AGENT_PARENT_ZNODE = "/hbase/chaosAgents";
    private static final String CHAOS_AGENT_STATUS_ZNODE = "/hbase/chaosAgentTaskStatus";
    private static final String ZNODE_PATH_SEPARATOR = "/";
    private static final String TASK_PREFIX = "task_";
    private static final String TASK_ERROR_STRING = "error";
    private static final String TASK_COMPLETION_STRING = "done";
    private static final String TASK_BOOLEAN_TRUE = "true";
    private static final String TASK_BOOLEAN_FALSE = "false";
    private static final String CONNECTION_LOSS = "ConnectionLoss";
    private static final int SESSION_TIMEOUT_ZK = 600000;
    private static final int TASK_EXECUTION_TIMEOUT = 300000;
    private volatile String taskStatus = null;
    private final String quorum;
    private ZooKeeper zk;
    Watcher setStatusWatcher = new Watcher(){

        public void process(WatchedEvent watchedEvent) {
            LOG.info("Setting status watch for task: " + watchedEvent.getPath());
            if (watchedEvent.getType() == Watcher.Event.EventType.NodeDataChanged) {
                if (!watchedEvent.getPath().contains(ChaosZKClient.TASK_PREFIX)) {
                    throw new RuntimeException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.DATAINCONSISTENCY));
                }
                ChaosZKClient.this.getStatus(watchedEvent.getPath(), watchedEvent.getPath());
            }
        }
    };
    AsyncCallback.DataCallback getStatusCallback = (rc, path, ctx, data, stat) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                this.recreateZKConnection();
                this.getStatus(path, ctx);
                break;
            }
            case OK: {
                String status;
                if (ctx == null) break;
                this.taskStatus = status = new String(data, StandardCharsets.UTF_8);
                switch (status) {
                    case "done": 
                    case "true": 
                    case "false": {
                        LOG.info("Task executed completely : Status --> " + status);
                        break;
                    }
                    case "error": {
                        LOG.info("There was error while executing task : Status --> " + status);
                        break;
                    }
                    default: {
                        LOG.warn("Status of task is undefined!! : Status --> " + status);
                    }
                }
                this.deleteTask(path);
                break;
            }
            default: {
                LOG.error("ERROR while getting status of task: " + path + " ERROR: " + KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }
    };
    AsyncCallback.StatCallback setStatusWatchCallback = (rc, path, ctx, stat) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                this.recreateZKConnection();
                this.setStatusWatch(path, (TaskObject)ctx);
                break;
            }
            case OK: {
                if (stat == null) break;
                this.getStatus(path, null);
                break;
            }
            default: {
                LOG.error("ERROR while setting watch on task ZNode: " + path + " ERROR: " + KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }
    };
    AsyncCallback.StringCallback submitTaskCallback = (rc, path, ctx, name) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                this.recreateZKConnection();
                this.submitTask((TaskObject)ctx);
                break;
            }
            case OK: {
                LOG.info("Task created : " + name);
                this.setStatusWatch(name, (TaskObject)ctx);
                break;
            }
            default: {
                LOG.error("Error submitting task: " + name + " ERROR:" + KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }
    };
    AsyncCallback.VoidCallback taskDeleteCallback = new AsyncCallback.VoidCallback(){

        public void processResult(int rc, String path, Object ctx) {
            switch (KeeperException.Code.get((int)rc)) {
                case CONNECTIONLOSS: {
                    ChaosZKClient.this.recreateZKConnection();
                    ChaosZKClient.this.deleteTask(path);
                    break;
                }
                case OK: {
                    LOG.info("Task Deleted successfully!");
                    LOG.info("Closing ZooKeeper Connection");
                    try {
                        ChaosZKClient.this.zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error while closing ZooKeeper Connection.");
                    }
                    break;
                }
                default: {
                    LOG.error("ERROR while deleting task: " + path + " ERROR: " + KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }
        }
    };

    public ChaosZKClient(String quorum) {
        this.quorum = quorum;
        try {
            this.createNewZKConnection();
        }
        catch (IOException e) {
            LOG.error("Error creating ZooKeeper Connection: ", (Throwable)e);
        }
    }

    public void createNewZKConnection() throws IOException {
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                LOG.info("Created ZooKeeper Connection For executing task");
            }
        };
        this.zk = new ZooKeeper(this.quorum, 600000, watcher);
    }

    private boolean isChaosAgentRunning(String hostname) {
        try {
            return this.zk.exists("/hbase/chaosAgents/" + hostname, false) != null;
        }
        catch (KeeperException e) {
            if (e.toString().contains(CONNECTION_LOSS)) {
                this.recreateZKConnection();
                try {
                    return this.zk.exists("/hbase/chaosAgents/" + hostname, false) != null;
                }
                catch (InterruptedException | KeeperException ie) {
                    LOG.error("ERROR ", ie);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error checking for given hostname: {} ERROR: ", (Object)hostname, (Object)e);
        }
        return false;
    }

    public String submitTask(TaskObject taskObject) {
        if (this.isChaosAgentRunning(taskObject.getTaskHostname())) {
            LOG.info("Creating task node");
            this.zk.create("/hbase/chaosAgentTaskStatus/" + taskObject.getTaskHostname() + ZNODE_PATH_SEPARATOR + TASK_PREFIX, taskObject.getCommand().getBytes(StandardCharsets.UTF_8), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, this.submitTaskCallback, (Object)taskObject);
            long start = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() - start < 300000L) {
                if (this.taskStatus != null) {
                    return this.taskStatus;
                }
                Threads.sleep((long)500L);
            }
        } else {
            LOG.info("EHHHHH!  ChaosAgent Not running");
        }
        return TASK_ERROR_STRING;
    }

    private void getStatus(String path, Object ctx) {
        LOG.info("Getting Status of task: " + path);
        this.zk.getData(path, false, this.getStatusCallback, ctx);
    }

    private void setStatusWatch(String name, TaskObject taskObject) {
        LOG.info("Checking for ZNode and Setting watch for task : " + name);
        this.zk.exists(name, this.setStatusWatcher, this.setStatusWatchCallback, (Object)taskObject);
    }

    private void deleteTask(String path) {
        LOG.info("Deleting task: " + path);
        this.zk.delete(path, -1, this.taskDeleteCallback, null);
    }

    private void recreateZKConnection() {
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            LOG.error("Error closing ZK connection : ", (Throwable)e);
        }
        finally {
            try {
                this.createNewZKConnection();
            }
            catch (IOException e) {
                LOG.error("Error creating new ZK COnnection for agent: ", (Throwable)e);
            }
        }
    }

    static class TaskObject {
        private final String command;
        private final String taskHostname;

        public TaskObject(String command, String taskHostname) {
            this.command = command;
            this.taskHostname = taskHostname;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTaskHostname() {
            return this.taskHostname;
        }
    }
}

