/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorruptDataFilesAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(CorruptDataFilesAction.class);
    private final float chance;

    public CorruptDataFilesAction(float chance) {
        this.chance = chance * 100.0f;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Exception {
        this.getLogger().info("Start corrupting data files");
        FileSystem fs = CommonFSUtils.getRootDirFileSystem((Configuration)this.getConf());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)this.getConf());
        Path defaultDir = rootDir.suffix("/data/default");
        RemoteIterator iterator = fs.listFiles(defaultDir, true);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        while (iterator.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)iterator.next();
            if (!HFile.isHFileFormat((FileSystem)fs, (Path)status.getPath()) || 100.0f * ((Random)rand).nextFloat() > this.chance) continue;
            try (FSDataOutputStream out = fs.create(status.getPath(), true);){
                out.write(0);
            }
            this.getLogger().info("Corrupting {}", (Object)status.getPath());
        }
        this.getLogger().info("Done corrupting data files");
    }
}

