/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.HistogramStatistics;

@Internal
public class StatsSummarySnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long min;
    private final long max;
    private final long sum;
    private final long count;
    @Nullable
    private final HistogramStatistics histogram;

    public StatsSummarySnapshot(long min, long max, long sum, long count, @Nullable HistogramStatistics histogram) {
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
        this.histogram = histogram;
    }

    public static StatsSummarySnapshot empty() {
        return new StatsSummarySnapshot(0L, 0L, 0L, 0L, null);
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getAverage() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.sum / this.count;
    }

    public double getQuantile(double quantile) {
        return this.histogram == null ? Double.NaN : this.histogram.getQuantile(quantile);
    }
}

