/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;

public class StatusDurationUtils {
    public static Map<ExecutionState, Long> getExecutionStateDuration(AccessExecution execution) {
        HashMap<ExecutionState, Long> executionStateDuration = new HashMap<ExecutionState, Long>();
        long now = System.currentTimeMillis();
        ExecutionState state = execution.getState();
        executionStateDuration.put(ExecutionState.CREATED, StatusDurationUtils.calculateStateDuration(execution.getStateTimestamp(ExecutionState.CREATED), state == ExecutionState.CREATED ? now : execution.getStateEndTimestamp(ExecutionState.CREATED)));
        executionStateDuration.put(ExecutionState.SCHEDULED, StatusDurationUtils.calculateStateDuration(execution.getStateTimestamp(ExecutionState.SCHEDULED), state == ExecutionState.SCHEDULED ? now : execution.getStateEndTimestamp(ExecutionState.SCHEDULED)));
        executionStateDuration.put(ExecutionState.DEPLOYING, StatusDurationUtils.calculateStateDuration(execution.getStateTimestamp(ExecutionState.DEPLOYING), state == ExecutionState.DEPLOYING ? now : execution.getStateEndTimestamp(ExecutionState.DEPLOYING)));
        executionStateDuration.put(ExecutionState.INITIALIZING, StatusDurationUtils.calculateStateDuration(execution.getStateTimestamp(ExecutionState.INITIALIZING), state == ExecutionState.INITIALIZING ? now : execution.getStateEndTimestamp(ExecutionState.INITIALIZING)));
        executionStateDuration.put(ExecutionState.RUNNING, StatusDurationUtils.calculateStateDuration(execution.getStateTimestamp(ExecutionState.RUNNING), state == ExecutionState.RUNNING ? now : execution.getStateEndTimestamp(ExecutionState.RUNNING)));
        return executionStateDuration;
    }

    private static long calculateStateDuration(long start, long end) {
        if (start == 0L || end == 0L) {
            return -1L;
        }
        return end - start;
    }
}

