/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.auth;

import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import java.util.ArrayList;

public class AuthUtils {
    public static void validateConfigPresent(DriverExecutionProfile config, String authenticatorName, EndPoint endPoint, DriverOption ... options) {
        ArrayList<DriverOption> missingOptions = new ArrayList<DriverOption>();
        for (DriverOption option : options) {
            if (!config.isDefined(option)) {
                missingOptions.add(option);
            }
            if (missingOptions.size() <= 0) continue;
            String message = "Missing required configuration options for authenticator " + authenticatorName + ":";
            for (DriverOption missingOption : missingOptions) {
                message = message + " " + missingOption.getPath();
            }
            throw new AuthenticationException(endPoint, message);
        }
    }
}

