/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.StringValue;

@PublicEvolving
public final class StringValueUtils {
    public static void toLowerCase(StringValue string) {
        char[] chars = string.getCharArray();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            chars[i] = Character.toLowerCase(chars[i]);
        }
    }

    public static void replaceNonWordChars(StringValue string, char replacement) {
        char[] chars = string.getCharArray();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_') continue;
            chars[i] = replacement;
        }
    }

    private StringValueUtils() {
    }

    public static final class WhitespaceTokenizer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue toTokenize;
        private int pos;
        private int limit;

        public void setStringToTokenize(StringValue string) {
            this.toTokenize = string;
            this.pos = 0;
            this.limit = string.length();
        }

        public boolean next(StringValue target) {
            int pos;
            char[] data = this.toTokenize.getCharArray();
            int limit = this.limit;
            for (pos = this.pos; pos < limit && Character.isWhitespace(data[pos]); ++pos) {
            }
            if (pos >= limit) {
                this.pos = pos;
                return false;
            }
            int start = pos;
            while (pos < limit && !Character.isWhitespace(data[pos])) {
                ++pos;
            }
            this.pos = pos;
            target.setValue(this.toTokenize, start, pos - start);
            return true;
        }
    }
}

