/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.stateful.SparkTimerInternals;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class TimerUtils {
    public static <W extends BoundedWindow> void dropExpiredTimers(@UnknownKeyFor @NonNull @Initialized SparkTimerInternals sparkTimerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        Collection expiredTimers = sparkTimerInternals.getTimers().stream().filter(timer -> timer.getTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)sparkTimerInternals.currentInputWatermarkTime())).collect(Collectors.toList());
        expiredTimers.forEach(sparkTimerInternals::deleteTimer);
    }
}

